/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.ipc.sink.kafka.client;

import com.google.protobuf.ByteString;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.apache.kafka.common.serialization.StringSerializer;
import org.opennms.core.camel.JmsQueueNameFactory;
import org.opennms.core.ipc.common.kafka.OsgiKafkaConfigProvider;
import org.opennms.core.ipc.common.kafka.Utils;
import org.opennms.core.ipc.sink.api.Message;
import org.opennms.core.ipc.sink.api.SinkModule;
import org.opennms.core.ipc.sink.common.AbstractMessageDispatcherFactory;
import org.opennms.core.ipc.sink.kafka.client.KafkaLocalMessageDispatcherFactory;
import org.opennms.core.ipc.sink.model.SinkMessageProtos;
import org.opennms.core.logging.Logging;
import org.osgi.framework.BundleContext;
import org.osgi.service.cm.ConfigurationAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaRemoteMessageDispatcherFactory
extends AbstractMessageDispatcherFactory<String> {
    private static final Logger LOG = LoggerFactory.getLogger(KafkaRemoteMessageDispatcherFactory.class);
    private final Properties kafkaConfig = new Properties();
    private ConfigurationAdmin configAdmin;
    private BundleContext bundleContext;
    private KafkaProducer<String, byte[]> producer;

    public <S extends Message, T extends Message> String getModuleMetadata(SinkModule<S, T> module) {
        JmsQueueNameFactory topicNameFactory = new JmsQueueNameFactory("Sink", module.getId());
        return topicNameFactory.getName();
    }

    public <S extends Message, T extends Message> void dispatch(SinkModule<S, T> module, String topic, T message) {
        try (Logging.MDCCloseable mdc = Logging.withPrefixCloseable((String)"ipc");){
            LOG.trace("dispatch({}): sending message {}", (Object)topic, message);
            String messageId = UUID.randomUUID().toString();
            byte[] messageInBytes = this.wrapMessageToProto(messageId, module.marshal(message));
            ProducerRecord record = new ProducerRecord(topic, (Object)messageId, (Object)messageInBytes);
            while (true) {
                try {
                    Future future = this.producer.send(record);
                    future.get();
                }
                catch (InterruptedException e) {
                    LOG.warn("Interrupted while sending message to topic {}.", (Object)topic, (Object)e);
                    Thread.currentThread().interrupt();
                }
                catch (ExecutionException e) {
                    if (e.getCause() != null && e.getCause() instanceof TimeoutException) {
                        LOG.warn("Timeout occured while sending message to topic {}, it will be attempted again.", (Object)topic);
                        continue;
                    }
                    LOG.error("Exception occured while sending message to topic {} ", (Throwable)e);
                }
                break;
            }
        }
    }

    private byte[] wrapMessageToProto(String messageId, byte[] messageInBytes) {
        SinkMessageProtos.SinkMessage sinkMessage = SinkMessageProtos.SinkMessage.newBuilder().setMessageId(messageId).setContent(ByteString.copyFrom((byte[])messageInBytes)).build();
        return sinkMessage.toByteArray();
    }

    public void init() throws IOException {
        try (Logging.MDCCloseable mdc = Logging.withPrefixCloseable((String)"ipc");){
            this.kafkaConfig.clear();
            this.kafkaConfig.put("key.serializer", StringSerializer.class.getCanonicalName());
            this.kafkaConfig.put("value.serializer", ByteArraySerializer.class.getCanonicalName());
            OsgiKafkaConfigProvider configProvider = new OsgiKafkaConfigProvider("org.opennms.core.ipc.sink.kafka", this.configAdmin);
            this.kafkaConfig.putAll((Map<?, ?>)configProvider.getProperties());
            LOG.info("KafkaRemoteMessageDispatcherFactory: initializing the Kafka producer with: {}", (Object)this.kafkaConfig);
            this.producer = (KafkaProducer)Utils.runWithGivenClassLoader(() -> new KafkaProducer(this.kafkaConfig), (ClassLoader)KafkaProducer.class.getClassLoader());
            this.onInit();
        }
    }

    public void destroy() {
        this.onDestroy();
        if (this.producer != null) {
            this.producer.close();
            this.producer = null;
        }
    }

    public String getMetricDomain() {
        return KafkaLocalMessageDispatcherFactory.class.getPackage().getName();
    }

    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    public void setConfigAdmin(ConfigurationAdmin configAdmin) {
        this.configAdmin = configAdmin;
    }

    public void setBundleContext(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }
}

