/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.rpc.aws.sqs;

import java.util.Objects;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.jms.JmsEndpoint;
import org.apache.camel.model.RouteDefinition;
import org.opennms.core.ipc.common.aws.sqs.AmazonSQSManager;
import org.opennms.core.rpc.api.RpcModule;
import org.opennms.core.rpc.api.RpcRequest;
import org.opennms.core.rpc.api.RpcResponse;
import org.opennms.core.rpc.aws.sqs.AmazonSQSServerProcessor;
import org.opennms.core.rpc.aws.sqs.SystemIdFilterProcessor;
import org.opennms.core.rpc.camel.CamelRpcServerRouteManager;
import org.opennms.distributed.core.api.MinionIdentity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AmazonSQSServerRouteManager
extends CamelRpcServerRouteManager {
    private static final Logger LOG = LoggerFactory.getLogger(CamelRpcServerRouteManager.class);
    private final AmazonSQSManager sqsManager;

    public AmazonSQSServerRouteManager(CamelContext context, MinionIdentity identity, AmazonSQSManager sqsManager) {
        super(context, identity);
        this.sqsManager = Objects.requireNonNull(sqsManager);
    }

    public RouteBuilder getRouteBuilder(CamelContext context, MinionIdentity identity, RpcModule<RpcRequest, RpcResponse> module) {
        return new DynamicRpcRouteBuilder(this.sqsManager, context, identity, module);
    }

    private static final class DynamicRpcRouteBuilder
    extends RouteBuilder {
        private final AmazonSQSManager sqsManager;
        private final MinionIdentity identity;
        private final RpcModule<RpcRequest, RpcResponse> module;

        private DynamicRpcRouteBuilder(AmazonSQSManager sqsManager, CamelContext context, MinionIdentity identity, RpcModule<RpcRequest, RpcResponse> module) {
            super(context);
            this.sqsManager = sqsManager;
            this.identity = identity;
            this.module = module;
        }

        public void configure() throws Exception {
            String requestQueueName = this.sqsManager.getRpcRequestQueueNameAndCreateIfNecessary(this.module.getId(), this.identity.getLocation());
            JmsEndpoint endpoint = (JmsEndpoint)this.getContext().getEndpoint(String.format("jms:queue:%s?connectionFactory=#connectionFactory&correlationProperty=%s&asyncConsumer=true", requestQueueName, "RPCCorrelationId"), JmsEndpoint.class);
            ((RouteDefinition)((RouteDefinition)((RouteDefinition)this.from((Endpoint)endpoint).setExchangePattern(ExchangePattern.InOut)).process((Processor)new SystemIdFilterProcessor(this.identity.getId()))).process((Processor)new AmazonSQSServerProcessor(this.module))).routeId(CamelRpcServerRouteManager.getRouteId(this.module));
        }
    }
}

