/*
 * Decompiled with CFR 0.152.
 */
package org.sblim.slp.internal.msg;

import java.io.IOException;
import java.util.List;
import org.sblim.slp.ServiceLocationException;
import org.sblim.slp.ServiceURL;
import org.sblim.slp.internal.msg.MsgHeader;
import org.sblim.slp.internal.msg.SLPInputStream;
import org.sblim.slp.internal.msg.SLPMessage;
import org.sblim.slp.internal.msg.SLPOutputStream;
import org.sblim.slp.internal.msg.SerializeOption;

public class ServiceRegistration
extends SLPMessage {
    private ServiceURL iServURL;
    private List iScopeList;
    private List iAttrList;
    private List iAuthBlockList;

    public static SLPMessage parse(MsgHeader pHdr, SLPInputStream pInStr) throws ServiceLocationException, IOException {
        ServiceURL url = pInStr.readURL();
        pInStr.readServiceType();
        return new ServiceRegistration(pHdr, url, pInStr.readStringList(), pInStr.readAttributeList(), pInStr.readAuthBlockList());
    }

    public ServiceRegistration(ServiceURL pServURL, List pScopeList, List pAttrList, List pAuthBlockList) {
        super(3);
        this.init(pServURL, pScopeList, pAttrList, pAuthBlockList);
    }

    public ServiceRegistration(String pLangTag, ServiceURL pServURL, List pScopeList, List pAttrList, List pAuthBlockList) {
        super(3, pLangTag);
        this.init(pServURL, pScopeList, pAttrList, pAuthBlockList);
    }

    public ServiceRegistration(MsgHeader pHeader, ServiceURL pServURL, List pScopeList, List pAttrList, List pAuthBlockList) {
        super(pHeader);
        this.init(pServURL, pScopeList, pAttrList, pAuthBlockList);
    }

    public ServiceURL getServiceURL() {
        return this.iServURL;
    }

    public List getScopeList() {
        return this.iScopeList;
    }

    public List getAttributeList() {
        return this.iAttrList;
    }

    protected boolean serializeBody(SLPOutputStream pOutStr, SerializeOption pOption) {
        return pOutStr.write(this.iServURL) && pOutStr.write(this.iServURL.getServiceType()) && pOutStr.writeStringList(this.iScopeList) && pOutStr.writeAttributeList(this.iAttrList) && pOutStr.writeAuthBlockList(this.iAuthBlockList);
    }

    private void init(ServiceURL pServURL, List pScopeList, List pAttrList, List pAuthBlockList) {
        this.iServURL = pServURL;
        this.iScopeList = pScopeList;
        this.iAttrList = pAttrList;
        this.iAuthBlockList = pAuthBlockList;
    }
}

