/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.detector.dhcp;

import org.opennms.features.dhcpd.Dhcpd;
import org.opennms.netmgt.provision.detector.dhcp.client.DhcpClient;
import org.opennms.netmgt.provision.detector.dhcp.request.DhcpRequest;
import org.opennms.netmgt.provision.detector.dhcp.response.DhcpResponse;
import org.opennms.netmgt.provision.support.BasicDetector;
import org.opennms.netmgt.provision.support.Client;
import org.opennms.netmgt.provision.support.ResponseValidator;

public class DhcpDetector
extends BasicDetector<DhcpRequest, DhcpResponse> {
    public static final int DEFAULT_RETRIES = 0;
    public static final int DEFAULT_TIMEOUT = 3000;
    public static final String DEFAULT_MAC_ADDRESS = "00:06:0D:BE:9C:B2";
    private String macAddress = "00:06:0D:BE:9C:B2";
    private boolean relayMode = false;
    private boolean extendedMode = false;
    private String myIpAddress = "127.0.0.1";
    private String requestIpAddress = "127.0.0.1";
    private Dhcpd dhcpd;

    public DhcpDetector() {
        super("DHCP", 0);
        this.setTimeout(3000);
        this.setRetries(0);
    }

    public void setDhcpd(Dhcpd dhcpd) {
        this.dhcpd = dhcpd;
    }

    protected void onInit() {
        this.expectBanner(DhcpDetector.responseTimeGreaterThan(-1L));
    }

    private static ResponseValidator<DhcpResponse> responseTimeGreaterThan(final long num) {
        return new ResponseValidator<DhcpResponse>(){

            public boolean validate(DhcpResponse response) {
                return response.validate(num);
            }
        };
    }

    protected Client<DhcpRequest, DhcpResponse> getClient() {
        return new DhcpClient(this.macAddress, this.relayMode, this.myIpAddress, this.extendedMode, this.requestIpAddress, this.getTimeout(), this.getRetries(), this.dhcpd);
    }

    public String getMacAddress() {
        return this.macAddress;
    }

    public void setMacAddress(String macAddress) {
        this.macAddress = macAddress;
    }

    public boolean isRelayMode() {
        return this.relayMode;
    }

    public void setRelayMode(boolean relayMode) {
        this.relayMode = relayMode;
    }

    public boolean isExtendedMode() {
        return this.extendedMode;
    }

    public void setExtendedMode(boolean extendedMode) {
        this.extendedMode = extendedMode;
    }

    public String getMyIpAddress() {
        return this.myIpAddress;
    }

    public void setMyIpAddress(String myIpAddress) {
        this.myIpAddress = myIpAddress;
    }

    public String getRequestIpAddress() {
        return this.requestIpAddress;
    }

    public void setRequestIpAddress(String requestIpAddress) {
        this.requestIpAddress = requestIpAddress;
    }
}

