/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.topologies.service.api;

import java.util.HashSet;
import java.util.Set;
import org.opennms.netmgt.topologies.service.api.OnmsTopologyEdge;
import org.opennms.netmgt.topologies.service.api.OnmsTopologyVertex;

public class OnmsTopology {
    public static final String NAMESPACE = "namespace";
    public static final String ICON_KEY = "iconKey";
    public static final String LABEL = "label";
    public static final String NODE_ID = "nodeID";
    public static final String TOOLTIP_TEXT = "tooltipText";
    public static final String SOURCE_IFINDEX = "sourceifindex";
    public static final String TARGET_IFINDEX = "targetifindex";
    public static final String TOPOLOGY_NAMESPACE_LINKD = "nodes";
    private Set<OnmsTopologyVertex> m_vertices = new HashSet<OnmsTopologyVertex>();
    private Set<OnmsTopologyEdge> m_edges = new HashSet<OnmsTopologyEdge>();
    private OnmsTopologyVertex m_defaultVertex;

    public OnmsTopologyVertex getVertex(String id) {
        return this.m_vertices.stream().filter(vertex -> id.equals(vertex.getId())).findAny().orElse(null);
    }

    public OnmsTopologyEdge getEdge(String id) {
        return this.m_edges.stream().filter(edge -> id.equals(edge.getId())).findAny().orElse(null);
    }

    public Set<OnmsTopologyVertex> getVertices() {
        return this.m_vertices;
    }

    public void setVertices(Set<OnmsTopologyVertex> vertices) {
        this.m_vertices = vertices;
    }

    public Set<OnmsTopologyEdge> getEdges() {
        return this.m_edges;
    }

    public void setEdges(Set<OnmsTopologyEdge> edges) {
        this.m_edges = edges;
    }

    public boolean hasVertex(String id) {
        return this.getVertex(id) != null;
    }

    public boolean hasEdge(String id) {
        return this.getEdge(id) != null;
    }

    public OnmsTopology clone() {
        OnmsTopology topo = new OnmsTopology();
        topo.setVertices(new HashSet<OnmsTopologyVertex>(this.m_vertices));
        topo.setEdges(new HashSet<OnmsTopologyEdge>(this.m_edges));
        topo.setDefaultVertex(this.m_defaultVertex);
        return topo;
    }

    public OnmsTopologyVertex getDefaultVertex() {
        return this.m_defaultVertex;
    }

    public void setDefaultVertex(OnmsTopologyVertex defaultVertex) {
        this.m_defaultVertex = defaultVertex;
    }
}

