/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.telemetry.protocols.sflow.parser.proto.flows;

import com.google.common.base.MoreObjects;
import com.google.common.primitives.UnsignedLong;
import java.nio.ByteBuffer;
import org.bson.BsonWriter;
import org.opennms.netmgt.telemetry.common.utils.BufferUtils;
import org.opennms.netmgt.telemetry.protocols.sflow.parser.InvalidPacketException;
import org.opennms.netmgt.telemetry.protocols.sflow.parser.proto.AsciiString;
import org.opennms.netmgt.telemetry.protocols.sflow.parser.proto.flows.FlowData;
import org.opennms.netmgt.telemetry.protocols.sflow.parser.proto.flows.HttpMethod;
import org.opennms.netmgt.telemetry.protocols.sflow.parser.proto.flows.Version;

public class HttpRequest
implements FlowData {
    public final HttpMethod method;
    public final Version protocol;
    public final AsciiString uri;
    public final AsciiString host;
    public final AsciiString referer;
    public final AsciiString useragent;
    public final AsciiString xff;
    public final AsciiString authuser;
    public final AsciiString mime_type;
    public final UnsignedLong req_bytes;
    public final UnsignedLong resp_bytes;
    public final long uS;
    public final Integer status;

    public HttpRequest(ByteBuffer buffer) throws InvalidPacketException {
        this.method = HttpMethod.from(buffer);
        this.protocol = new Version(buffer);
        this.uri = new AsciiString(buffer);
        this.host = new AsciiString(buffer);
        this.referer = new AsciiString(buffer);
        this.useragent = new AsciiString(buffer);
        this.xff = new AsciiString(buffer);
        this.authuser = new AsciiString(buffer);
        this.mime_type = new AsciiString(buffer);
        this.req_bytes = BufferUtils.uint64((ByteBuffer)buffer);
        this.resp_bytes = BufferUtils.uint64((ByteBuffer)buffer);
        this.uS = BufferUtils.uint32((ByteBuffer)buffer);
        this.status = BufferUtils.sint32((ByteBuffer)buffer);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("method", (Object)this.method).add("protocol", (Object)this.protocol).add("uri", (Object)this.uri).add("host", (Object)this.host).add("referer", (Object)this.referer).add("useragent", (Object)this.useragent).add("xff", (Object)this.xff).add("authuser", (Object)this.authuser).add("mime_type", (Object)this.mime_type).add("req_bytes", (Object)this.req_bytes).add("resp_bytes", (Object)this.resp_bytes).add("uS", this.uS).add("status", (Object)this.status).toString();
    }

    @Override
    public void writeBson(BsonWriter bsonWriter) {
        bsonWriter.writeStartDocument();
        bsonWriter.writeName("method");
        this.method.writeBson(bsonWriter);
        bsonWriter.writeName("protocol");
        this.protocol.writeBson(bsonWriter);
        bsonWriter.writeString("uri", this.uri.value);
        bsonWriter.writeString("host", this.host.value);
        bsonWriter.writeString("referer", this.referer.value);
        bsonWriter.writeString("useragent", this.useragent.value);
        bsonWriter.writeString("xff", this.xff.value);
        bsonWriter.writeString("authuser", this.authuser.value);
        bsonWriter.writeString("mime_type", this.mime_type.value);
        bsonWriter.writeInt64("req_bytes", this.req_bytes.longValue());
        bsonWriter.writeInt64("resp_bytes", this.resp_bytes.longValue());
        bsonWriter.writeInt64("uS", this.uS);
        bsonWriter.writeInt32("status", this.status.intValue());
        bsonWriter.writeEndDocument();
    }
}

