/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.telemetry.protocols.sflow.parser.proto;

import com.google.common.base.MoreObjects;
import java.nio.ByteBuffer;
import java.util.Optional;
import org.opennms.netmgt.telemetry.common.utils.BufferUtils;
import org.opennms.netmgt.telemetry.protocols.sflow.parser.InvalidPacketException;

public class Opaque<T> {
    public final int length;
    public final T value;

    public Opaque(ByteBuffer buffer, Optional<Integer> length, Parser<T> parser) throws InvalidPacketException {
        this.length = length.orElseGet(() -> (int)BufferUtils.uint32((ByteBuffer)buffer));
        this.value = parser.parse(BufferUtils.slice((ByteBuffer)buffer, (int)this.length));
        BufferUtils.skip((ByteBuffer)buffer, (int)((4 - this.length % 4) % 4));
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("length", this.length).add("value", this.value).toString();
    }

    public static <T> T parseUnknown(ByteBuffer buffer) throws InvalidPacketException {
        buffer.position(buffer.limit());
        return null;
    }

    public static byte[] parseBytes(ByteBuffer buffer) throws InvalidPacketException {
        return BufferUtils.bytes((ByteBuffer)buffer, (int)buffer.remaining());
    }

    @FunctionalInterface
    public static interface Parser<T> {
        public T parse(ByteBuffer var1) throws InvalidPacketException;
    }
}

