/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.telemetry.protocols.sflow.parser;

import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledExecutorService;
import org.bson.BsonBinaryWriter;
import org.bson.BsonWriter;
import org.bson.ByteBuf;
import org.bson.io.BasicOutputBuffer;
import org.bson.io.BsonOutput;
import org.opennms.core.ipc.sink.api.AsyncDispatcher;
import org.opennms.core.ipc.sink.api.Message;
import org.opennms.netmgt.telemetry.api.receiver.Dispatchable;
import org.opennms.netmgt.telemetry.api.receiver.TelemetryMessage;
import org.opennms.netmgt.telemetry.common.utils.BufferUtils;
import org.opennms.netmgt.telemetry.listeners.UdpParser;
import org.opennms.netmgt.telemetry.protocols.sflow.parser.proto.flows.DatagramVersion;
import org.opennms.netmgt.telemetry.protocols.sflow.parser.proto.flows.SampleDatagram;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SFlowUdpParser
implements UdpParser,
Dispatchable {
    private static final Logger LOG = LoggerFactory.getLogger(SFlowUdpParser.class);
    private final String name;
    private final AsyncDispatcher<TelemetryMessage> dispatcher;

    public SFlowUdpParser(String name, AsyncDispatcher<TelemetryMessage> dispatcher) {
        this.name = Objects.requireNonNull(name);
        this.dispatcher = Objects.requireNonNull(dispatcher);
    }

    public boolean handles(ByteBuffer buffer) {
        return BufferUtils.uint32((ByteBuffer)buffer) == (long)DatagramVersion.VERSION5.value;
    }

    public CompletableFuture<?> parse(ByteBuffer buffer, InetSocketAddress remoteAddress, InetSocketAddress localAddress) throws Exception {
        SampleDatagram packet = new SampleDatagram(buffer);
        LOG.trace("Got packet: {}", (Object)packet);
        BasicOutputBuffer output = new BasicOutputBuffer();
        try (BsonBinaryWriter bsonWriter = new BsonBinaryWriter((BsonOutput)output);){
            bsonWriter.writeStartDocument();
            bsonWriter.writeName("time");
            bsonWriter.writeInt64(System.currentTimeMillis());
            bsonWriter.writeName("data");
            packet.version.datagram.writeBson((BsonWriter)bsonWriter);
            bsonWriter.writeEndDocument();
        }
        TelemetryMessage msg = new TelemetryMessage(remoteAddress, ((ByteBuf)output.getByteBuffers().get(0)).asNIO());
        return this.dispatcher.send((Message)msg);
    }

    public String getName() {
        return null;
    }

    public void start(ScheduledExecutorService executorService) {
    }

    public void stop() {
    }
}

