/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.topologies.service.api;

import org.opennms.netmgt.topologies.service.api.OnmsTopologyException;
import org.opennms.netmgt.topologies.service.api.OnmsTopologyProtocol;
import org.opennms.netmgt.topologies.service.api.OnmsTopologyRef;

public class OnmsTopologyMessage {
    private final OnmsTopologyRef m_messagebody;
    private final TopologyMessageStatus m_messagestatus;
    private final OnmsTopologyProtocol m_protocol;

    public static OnmsTopologyMessage update(OnmsTopologyRef messagebody, OnmsTopologyProtocol protocol) throws OnmsTopologyException {
        OnmsTopologyMessage.checkOnmsTopologyMessage(messagebody, protocol, TopologyMessageStatus.UPDATE);
        return new OnmsTopologyMessage(messagebody, protocol, TopologyMessageStatus.UPDATE);
    }

    public static OnmsTopologyMessage delete(OnmsTopologyRef messagebody, OnmsTopologyProtocol protocol) throws OnmsTopologyException {
        OnmsTopologyMessage.checkOnmsTopologyMessage(messagebody, protocol, TopologyMessageStatus.DELETE);
        return new OnmsTopologyMessage(messagebody, protocol, TopologyMessageStatus.DELETE);
    }

    private static void checkOnmsTopologyMessage(OnmsTopologyRef messagebody, OnmsTopologyProtocol protocol, TopologyMessageStatus messagestatus) throws OnmsTopologyException {
        if (messagebody == null && protocol == null) {
            throw new OnmsTopologyException("Protocol and Ref null, cannot create message", messagestatus);
        }
        if (messagebody == null) {
            throw new OnmsTopologyException("Ref null, cannot create message", protocol, messagestatus);
        }
        if (protocol == null) {
            throw new OnmsTopologyException("Protocol null, cannot create message", messagebody, messagestatus);
        }
    }

    private <T extends OnmsTopologyRef> OnmsTopologyMessage(T messagebody, OnmsTopologyProtocol protocol, TopologyMessageStatus messagestatus) {
        this.m_messagebody = messagebody;
        this.m_messagestatus = messagestatus;
        this.m_protocol = protocol;
    }

    public OnmsTopologyRef getMessagebody() {
        return this.m_messagebody;
    }

    public TopologyMessageStatus getMessagestatus() {
        return this.m_messagestatus;
    }

    public OnmsTopologyProtocol getProtocol() {
        return this.m_protocol;
    }

    public static enum TopologyMessageStatus {
        UPDATE,
        DELETE;

    }
}

