/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.detector.wsman;

import java.net.InetAddress;
import java.util.Map;
import org.opennms.core.wsman.WSManClientFactory;
import org.opennms.core.wsman.cxf.CXFWSManClientFactory;
import org.opennms.netmgt.dao.WSManConfigDao;
import org.opennms.netmgt.dao.api.NodeDao;
import org.opennms.netmgt.provision.DetectRequest;
import org.opennms.netmgt.provision.detector.wsman.WsManWQLDetector;
import org.opennms.netmgt.provision.detector.wsman.WsmanEndpointUtils;
import org.opennms.netmgt.provision.support.DetectRequestImpl;
import org.opennms.netmgt.provision.support.GenericServiceDetectorFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class WsManWQLDetectorFactory
extends GenericServiceDetectorFactory<WsManWQLDetector> {
    private static final Logger LOG = LoggerFactory.getLogger(WsManWQLDetectorFactory.class);
    private final WSManClientFactory m_factory = new CXFWSManClientFactory();
    @Autowired
    private WSManConfigDao m_wsmanConfigDao;
    @Autowired
    private NodeDao m_nodeDao;

    public WsManWQLDetectorFactory() {
        super(WsManWQLDetector.class);
    }

    public WsManWQLDetector createDetector(Map<String, String> properties) {
        WsManWQLDetector detector = new WsManWQLDetector();
        detector.setClientFactory(this.m_factory);
        return detector;
    }

    public DetectRequest buildRequest(String location, InetAddress address, Integer port, Map<String, String> attributes) {
        return new DetectRequestImpl(address, port, WsmanEndpointUtils.toMap(this.m_wsmanConfigDao.getEndpoint(address)));
    }
}

