/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller.monitors;

import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.opennms.core.sysprops.SystemProperties;
import org.opennms.core.utils.ParameterMap;
import org.opennms.netmgt.poller.Distributable;
import org.opennms.netmgt.poller.MonitoredService;
import org.opennms.netmgt.poller.PollStatus;
import org.opennms.netmgt.poller.monitors.support.ParameterSubstitutingMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xbill.DNS.ExtendedResolver;
import org.xbill.DNS.Lookup;
import org.xbill.DNS.Name;
import org.xbill.DNS.Record;
import org.xbill.DNS.Resolver;
import org.xbill.DNS.SimpleResolver;
import org.xbill.DNS.TextParseException;
import org.xbill.DNS.Type;

@Distributable
public class DNSResolutionMonitor
extends ParameterSubstitutingMonitor {
    public static final Logger LOG = LoggerFactory.getLogger(DNSResolutionMonitor.class);
    public static final String PARM_RESOLUTION_TYPE = "resolution-type";
    public static final String PARM_RESOLUTION_TYPE_V4 = "v4";
    public static final String PARM_RESOLUTION_TYPE_V6 = "v6";
    public static final String PARM_RESOLUTION_TYPE_BOTH = "both";
    public static final String PARM_RESOLUTION_TYPE_EITHER = "either";
    public static final String PARM_RESOLUTION_TYPE_DEFAULT = "either";
    public static final String PARM_RECORD_TYPES = "record-types";
    public static final String PARM_RECORD_TYPE_A = "A";
    public static final String PARM_RECORD_TYPE_AAAA = "AAAA";
    public static final String PARM_RECORD_TYPE_CNAME = "CNAME";
    public static final String PARM_RECORD_TYPE_NS = "NS";
    public static final String PARM_RECORD_TYPE_MX = "MX";
    public static final String PARM_RECORD_TYPE_PTR = "PTR";
    public static final String PARM_RECORD_TYPE_SOA = "SOA";
    public static final String PARM_RECORD_TYPE_SRV = "SRV";
    public static final String PARM_RECORD_TYPE_TXT = "TXT";
    public static final String PARM_NAMESERVER = "nameserver";
    public static final String PARM_LOOKUP = "lookup";

    public PollStatus poll(MonitoredService svc, Map<String, Object> parameters) {
        ExtendedResolver resolver;
        Name name;
        String lookup = DNSResolutionMonitor.resolveKeyedString(parameters, (String)PARM_LOOKUP, (String)svc.getNodeLabel());
        try {
            name = new Name(lookup);
        }
        catch (TextParseException e) {
            return PollStatus.unavailable((String)("Invalid record name '" + lookup + "': " + e.getMessage()));
        }
        TreeSet<Integer> recordTypes = new TreeSet<Integer>();
        String resolutionType = ParameterMap.getKeyedString(parameters, (String)PARM_RESOLUTION_TYPE, (String)"either");
        String recordTypesParam = ParameterMap.getKeyedString(parameters, (String)PARM_RECORD_TYPES, (String)"");
        Boolean matchAll = Boolean.TRUE;
        if ("".equals(recordTypesParam)) {
            if (PARM_RESOLUTION_TYPE_V4.equalsIgnoreCase(resolutionType) || PARM_RESOLUTION_TYPE_BOTH.equalsIgnoreCase(resolutionType) || "either".equalsIgnoreCase(resolutionType)) {
                recordTypes.add(1);
            }
            if (PARM_RESOLUTION_TYPE_V6.equalsIgnoreCase(resolutionType) || PARM_RESOLUTION_TYPE_BOTH.equalsIgnoreCase(resolutionType) || "either".equalsIgnoreCase(resolutionType)) {
                recordTypes.add(28);
            }
            if ("either".equals(resolutionType)) {
                matchAll = Boolean.FALSE;
            }
        } else {
            for (String type : recordTypesParam.split(",")) {
                Integer typeValue = Type.value((String)type);
                if (typeValue == -1) {
                    LOG.error("Invalid record type '{}' specified in record-types list.", (Object)type);
                    continue;
                }
                recordTypes.add(typeValue);
            }
        }
        String nameserver = DNSResolutionMonitor.resolveKeyedString(parameters, (String)PARM_NAMESERVER, null);
        try {
            Object port;
            String hostname;
            if (nameserver == null) {
                resolver = new ExtendedResolver();
            } else if ("::1".equals(nameserver)) {
                resolver = new SimpleResolver(nameserver);
            } else if (nameserver.matches("^\\[[\\d:]+\\]:\\d+$")) {
                Integer pos = nameserver.lastIndexOf(":");
                hostname = nameserver.substring(0, pos);
                hostname = hostname.substring(1, hostname.length() - 1);
                port = Integer.valueOf(nameserver.substring(pos + 1));
                LOG.debug("nameserver: hostname={}, port={}", (Object)hostname, port);
                resolver = new SimpleResolver(hostname);
                resolver.setPort(((Integer)port).intValue());
            } else if (nameserver.matches("^\\S+:\\d+$")) {
                Integer pos = nameserver.lastIndexOf(":");
                hostname = nameserver.substring(0, pos);
                port = nameserver.substring(pos + 1);
                LOG.debug("nameserver: hostname={}, port={}", (Object)hostname, port);
                resolver = new SimpleResolver(hostname);
                resolver.setPort(SystemProperties.getInteger((String)port).intValue());
            } else {
                resolver = new SimpleResolver(nameserver);
            }
        }
        catch (UnknownHostException e) {
            return PollStatus.unavailable((String)("Unable to resolve nameserver '" + nameserver + "': " + e.getMessage()));
        }
        long start = System.currentTimeMillis();
        TreeSet foundTypes = new TreeSet();
        TreeSet notFoundTypes = new TreeSet();
        recordTypes.forEach(arg_0 -> DNSResolutionMonitor.lambda$poll$0(name, (Resolver)resolver, foundTypes, notFoundTypes, arg_0));
        long end = System.currentTimeMillis();
        LOG.debug("foundTypes: {}", foundTypes);
        LOG.debug("notFoundTypes: {}", notFoundTypes);
        if (foundTypes.isEmpty() && !notFoundTypes.isEmpty()) {
            return PollStatus.unavailable((String)("Unable to resolve host '" + name + "'"));
        }
        if (!foundTypes.isEmpty() && !notFoundTypes.isEmpty() && matchAll.booleanValue()) {
            return PollStatus.unavailable((String)("'" + name + "' could be resolved to types [" + foundTypes + "], but not for types [" + notFoundTypes + "]"));
        }
        return PollStatus.available((Double)Double.valueOf(end - start));
    }

    private static boolean resolve(Name name, Resolver resolver, int type) {
        Lookup lookup = new Lookup(name, type);
        lookup.setCache(null);
        lookup.setResolver(resolver);
        Record[] records = lookup.run();
        if (records == null) {
            return false;
        }
        return Arrays.stream(records).filter(r -> r.getType() == type).count() > 0L;
    }

    private static /* synthetic */ void lambda$poll$0(Name name, Resolver resolver, Set foundTypes, Set notFoundTypes, Integer type) {
        if (DNSResolutionMonitor.resolve(name, resolver, type)) {
            foundTypes.add(Type.string((int)type));
        } else {
            LOG.warn("Unable to resolve host '{}' for type '{}'", (Object)name, (Object)Type.string((int)type));
            notFoundTypes.add(Type.string((int)type));
        }
    }
}

