/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.protocols.icmp6;

import java.nio.ByteBuffer;
import org.opennms.protocols.icmp6.ICMPv6EchoPacket;
import org.opennms.protocols.icmp6.ICMPv6Packet;

public class ICMPv6EchoRequest
extends ICMPv6EchoPacket {
    public static final int PACKET_LENGTH = 64;

    public ICMPv6EchoRequest() {
        super(64);
        this.setType(ICMPv6Packet.Type.EchoRequest);
        this.setCode(0);
    }

    public ICMPv6EchoRequest(int size) {
        super(size);
        this.setType(ICMPv6Packet.Type.EchoRequest);
        this.setCode(0);
    }

    public ICMPv6EchoRequest(int id, int seqNum, long threadId) {
        this();
        this.setIdentifier(id);
        this.setSequenceNumber(seqNum);
        this.setThreadId(threadId);
        this.setCookie();
        ByteBuffer buf = this.getDataBuffer();
        for (int b = 40; b < buf.limit(); ++b) {
            buf.put(b, (byte)b);
        }
    }

    public ICMPv6EchoRequest(int id, int seqNum, long threadId, int size) {
        this(size);
        this.setIdentifier(id);
        this.setSequenceNumber(seqNum);
        this.setThreadId(threadId);
        this.setCookie();
        ByteBuffer buf = this.getDataBuffer();
        for (int b = 40; b < buf.limit(); ++b) {
            buf.put(b, (byte)b);
        }
    }
}

