/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.time;

import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CentralizedDateTimeFormat {
    public static final String SYSTEM_PROPERTY_DATE_FORMAT = "org.opennms.ui.datettimeformat";
    public static final String SESSION_PROPERTY_TIMEZONE_ID = "org.opennms.ui.timezoneid";
    public static final String DEFAULT_FORMAT_PATTERN = "yyyy-MM-dd'T'HH:mm:ssxxx";
    public static final Logger LOG = LoggerFactory.getLogger(CentralizedDateTimeFormat.class);
    private final DateTimeFormatter formatter = this.createFormatter();

    private DateTimeFormatter createFormatter() {
        DateTimeFormatter formatter;
        String format = this.getFormatPattern();
        try {
            formatter = DateTimeFormatter.ofPattern(format);
        }
        catch (IllegalArgumentException e) {
            LOG.warn(String.format("Can not use System Property %s=%s as dateformat, will fall back to default. Please see also java.time.format.DateTimeFormatter for the correct syntax", SYSTEM_PROPERTY_DATE_FORMAT, format), (Throwable)e);
            formatter = this.getDefaultFormatter();
        }
        return formatter;
    }

    public String getFormatPattern() {
        String format = System.getProperty(SYSTEM_PROPERTY_DATE_FORMAT);
        if (format == null) {
            format = DEFAULT_FORMAT_PATTERN;
        }
        return format;
    }

    private DateTimeFormatter getDefaultFormatter() {
        return new DateTimeFormatterBuilder().parseCaseInsensitive().append(DateTimeFormatter.ISO_LOCAL_DATE).appendLiteral('T').appendValue(ChronoField.HOUR_OF_DAY, 2).appendLiteral(':').appendValue(ChronoField.MINUTE_OF_HOUR, 2).optionalStart().appendLiteral(':').appendValue(ChronoField.SECOND_OF_MINUTE, 2).appendOffsetId().toFormatter();
    }

    public String format(Instant instant, ZoneId timeZoneId) {
        if (instant == null) {
            return null;
        }
        if (timeZoneId == null) {
            timeZoneId = ZoneId.systemDefault();
        }
        return this.formatter.withZone(timeZoneId).format(instant);
    }

    public String format(Date date, ZoneId timeZoneId) {
        if (date == null) {
            return null;
        }
        return this.format(date.toInstant(), timeZoneId);
    }
}

