/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim25.util.storage;

import com.vmware.vim25.HostScsiTopology;
import com.vmware.vim25.HostScsiTopologyInterface;
import com.vmware.vim25.HostScsiTopologyLun;
import com.vmware.vim25.HostScsiTopologyTarget;
import com.vmware.vim25.HostStorageDeviceInfo;
import com.vmware.vim25.ScsiLun;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class HostStorageDeviceInfoEx {
    Logger log = Logger.getLogger(HostStorageDeviceInfoEx.class);
    private HostStorageDeviceInfo storageDeviceInfo;
    public Map<String, String> scsiRuntimeNames = new HashMap<String, String>();

    public HostStorageDeviceInfoEx(HostStorageDeviceInfo storageDeviceInfo) {
        this.storageDeviceInfo = storageDeviceInfo;
        this.collectScsiRuntimeNames();
    }

    public Map getScsiRuntimeNames() {
        return this.scsiRuntimeNames;
    }

    public String getScsiRuntimeName(ScsiLun scsiLun) {
        return this.scsiRuntimeNames.get(scsiLun.key);
    }

    private void collectScsiRuntimeNames() {
        ArrayList<ScsiLun> sortedScsiLuns = new ArrayList<ScsiLun>();
        if (this.storageDeviceInfo.getScsiLun().length == 0) {
            this.log.trace((Object)"There are no Scsi LUNS on this storage device.");
            return;
        }
        for (ScsiLun lun : this.storageDeviceInfo.getScsiLun()) {
            if (!lun.lunType.equals("disk")) continue;
            sortedScsiLuns.add(lun);
        }
        ArrayList scsiTopologyInfo = new ArrayList();
        HostScsiTopology scsiTopology = this.storageDeviceInfo.scsiTopology;
        if (null == scsiTopology.adapter || scsiTopology.adapter.length == 0) {
            this.log.trace((Object)"There are no adapters on this storage device.");
            return;
        }
        for (HostScsiTopologyInterface hostScsiTopologyInterface : scsiTopology.adapter) {
            if (null == hostScsiTopologyInterface.target || hostScsiTopologyInterface.target.length == 0) {
                this.log.trace((Object)("This adapter has no targets. Adapter:" + hostScsiTopologyInterface.adapter));
                continue;
            }
            for (HostScsiTopologyTarget target : hostScsiTopologyInterface.target) {
                if (null == target.lun || target.lun.length == 0) {
                    this.log.trace((Object)("This target has no LUNs on it. Target:" + target.key));
                    continue;
                }
                for (HostScsiTopologyLun lun : target.lun) {
                    HashMap<String, Object> scsiInfo = new HashMap<String, Object>();
                    scsiInfo.put("key", target.key);
                    scsiInfo.put("lunInfo", lun);
                    scsiTopologyInfo.add(scsiInfo);
                }
            }
        }
        if (sortedScsiLuns.size() == 0 || scsiTopologyInfo.size() == 0) {
            this.log.trace((Object)"There is no SCSI Lun information on this host");
            return;
        }
        for (ScsiLun lun : sortedScsiLuns) {
            for (Map map : scsiTopologyInfo) {
                HostScsiTopologyLun scsiTopologyLun = (HostScsiTopologyLun)map.get("lunInfo");
                if (!scsiTopologyLun.scsiLun.equals(lun.key)) continue;
                String[] names = map.get("key").toString().split("-");
                String name = names[names.length - 1];
                String[] nameSplit = name.split(":");
                this.scsiRuntimeNames.put(lun.key, nameSplit[0] + ":C" + nameSplit[1] + ":T" + nameSplit[2] + ":L" + scsiTopologyLun.getLun());
            }
        }
    }
}

