/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config;

import java.io.File;
import java.io.IOException;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.opennms.core.utils.ConfigFileConstants;
import org.opennms.core.xml.JaxbUtils;
import org.opennms.netmgt.config.api.CatFactory;
import org.opennms.netmgt.config.categories.Category;
import org.opennms.netmgt.config.categories.CategoryGroup;
import org.opennms.netmgt.config.categories.Catinfo;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;

public final class CategoryFactory
implements CatFactory {
    private final ReadWriteLock m_globalLock = new ReentrantReadWriteLock();
    private final Lock m_readLock = this.m_globalLock.readLock();
    private final Lock m_writeLock = this.m_globalLock.writeLock();
    private static CatFactory m_singleton = null;
    private Catinfo m_config;
    private static boolean m_loaded = false;

    private CategoryFactory(String configFile) throws IOException {
        this((Resource)new FileSystemResource(configFile));
    }

    public CategoryFactory(Resource resource) throws IOException {
        this.m_config = (Catinfo)JaxbUtils.unmarshal(Catinfo.class, (Resource)resource);
    }

    public Lock getReadLock() {
        return this.m_readLock;
    }

    public Lock getWriteLock() {
        return this.m_writeLock;
    }

    public static synchronized void init() throws IOException {
        if (m_loaded) {
            return;
        }
        File cfgFile = ConfigFileConstants.getFile((int)ConfigFileConstants.CATEGORIES_CONF_FILE_NAME);
        CategoryFactory.setInstance(new CategoryFactory(cfgFile.getPath()));
    }

    public static synchronized void reload() throws IOException {
        m_singleton = null;
        m_loaded = false;
        CategoryFactory.init();
    }

    public static synchronized CatFactory getInstance() {
        if (!m_loaded) {
            throw new IllegalStateException("The factory has not been initialized");
        }
        return m_singleton;
    }

    public static void setInstance(CatFactory singleton) {
        m_singleton = singleton;
        m_loaded = true;
    }

    public Catinfo getConfig() {
        try {
            this.getReadLock().lock();
            Catinfo catinfo = this.m_config;
            return catinfo;
        }
        finally {
            this.getReadLock().unlock();
        }
    }

    public void addCategoryGroup(CategoryGroup group) {
        try {
            this.getWriteLock().lock();
            this.m_config.addCategoryGroup(group);
        }
        finally {
            this.getWriteLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean replaceCategoryGroup(CategoryGroup group) {
        try {
            this.getWriteLock().lock();
            String groupname = group.getName();
            int i = 0;
            while (i < this.m_config.getCategoryGroups().size()) {
                int index1 = i++;
                CategoryGroup oldCg = (CategoryGroup)this.m_config.getCategoryGroups().get(index1);
                if (!oldCg.getName().equals(groupname)) continue;
                int index = i;
                this.m_config.getCategoryGroups().set(index, group);
                boolean bl = true;
                return bl;
            }
        }
        finally {
            this.getWriteLock().unlock();
        }
        return false;
    }

    public boolean deleteCategoryGroup(CategoryGroup group) {
        try {
            this.getWriteLock().lock();
            boolean bl = this.m_config.removeCategoryGroup(group);
            return bl;
        }
        finally {
            this.getWriteLock().unlock();
        }
    }

    public boolean deleteCategoryGroup(String groupname) {
        try {
            this.getWriteLock().lock();
            boolean bl = this.m_config.removeCategoryGroup(groupname);
            return bl;
        }
        finally {
            this.getWriteLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addCategory(String groupname, Category cat) {
        try {
            this.getWriteLock().lock();
            for (CategoryGroup cg : this.m_config.getCategoryGroups()) {
                if (!cg.getName().equals(groupname)) continue;
                cg.addCategory(cat);
                boolean bl = true;
                return bl;
            }
        }
        finally {
            this.getWriteLock().unlock();
        }
        return false;
    }

    public boolean replaceCategory(String groupname, Category cat) {
        try {
            this.getWriteLock().lock();
            this.m_config.replaceCategoryInGroup(groupname, cat);
        }
        finally {
            this.getWriteLock().unlock();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteCategory(String groupname, Category cat) {
        try {
            this.getWriteLock().lock();
            for (CategoryGroup cg : this.m_config.getCategoryGroups()) {
                if (!cg.getName().equals(groupname)) continue;
                cg.removeCategory(cat);
                boolean bl = true;
                return bl;
            }
        }
        finally {
            this.getWriteLock().unlock();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteCategory(String groupname, String catlabel) {
        try {
            this.getWriteLock().lock();
            for (CategoryGroup cg : this.m_config.getCategoryGroups()) {
                if (!cg.getName().equals(groupname)) continue;
                cg.removeCategory(catlabel);
            }
        }
        finally {
            this.getWriteLock().unlock();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Category getCategory(String name) {
        try {
            this.getReadLock().lock();
            for (CategoryGroup cg : this.m_config.getCategoryGroups()) {
                for (Category cat : cg.getCategories()) {
                    if (!cat.getLabel().equals(name)) continue;
                    Category category = cat;
                    return category;
                }
            }
        }
        finally {
            this.getReadLock().unlock();
        }
        return null;
    }

    public double getNormal(String catlabel) {
        Category cat = this.getCategory(catlabel);
        return cat == null ? -1.0 : cat.getNormalThreshold();
    }

    public double getWarning(String catlabel) {
        Category cat = this.getCategory(catlabel);
        return cat == null ? -1.0 : cat.getWarningThreshold();
    }

    public String[] getServices(String catlabel) {
        Category cat = this.getCategory(catlabel);
        return cat == null ? null : cat.getServices().toArray(new String[0]);
    }

    public String getRule(String catlabel) {
        Category cat = this.getCategory(catlabel);
        return cat == null ? null : cat.getRule();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getEffectiveRule(String catlabel) {
        try {
            this.getReadLock().lock();
            for (CategoryGroup cg : this.m_config.getCategoryGroups()) {
                for (Category cat : cg.getCategories()) {
                    if (!cat.getLabel().equals(catlabel)) continue;
                    String string = "(" + cg.getCommon().getRule() + ") & (" + cat.getRule() + ")";
                    return string;
                }
            }
        }
        finally {
            this.getReadLock().unlock();
        }
        return null;
    }
}

