/*
 * Decompiled with CFR 0.152.
 */
package org.linkedin.util.concurrent;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.Condition;
import org.linkedin.util.clock.Clock;
import org.linkedin.util.clock.ClockUtils;
import org.linkedin.util.clock.SystemClock;

public class ConcurrentUtils {
    public static void awaitUntil(Condition condition, long endTime) throws InterruptedException, TimeoutException {
        ConcurrentUtils.awaitUntil((Clock)SystemClock.INSTANCE, condition, endTime);
    }

    public static void awaitUntil(Clock clock, Condition condition, long endTime) throws InterruptedException, TimeoutException {
        if (endTime <= 0L) {
            condition.await();
        } else {
            long now = clock.currentTimeMillis();
            if (now >= endTime) {
                throw new TimeoutException("timeout reached while waiting on the lock: " + condition);
            }
            if (!condition.await(endTime - now, TimeUnit.MILLISECONDS)) {
                throw new TimeoutException("timeout reached while waiting on the lock: " + condition);
            }
        }
    }

    public static void awaitUntil(Object lock, long endTime) throws InterruptedException, TimeoutException {
        ConcurrentUtils.awaitUntil((Clock)SystemClock.INSTANCE, lock, endTime);
    }

    public static void awaitUntil(Clock clock, Object lock, long endTime) throws InterruptedException, TimeoutException {
        if (endTime <= 0L) {
            lock.wait();
        } else {
            long now = clock.currentTimeMillis();
            if (now >= endTime) {
                throw new TimeoutException("timeout reached while waiting on the lock: " + lock);
            }
            lock.wait(endTime - now);
        }
    }

    public static void joinUntil(Clock clock, Thread thread, long endTime) throws InterruptedException, TimeoutException {
        if (endTime <= 0L) {
            thread.join();
        } else {
            while (thread.isAlive()) {
                long now = clock.currentTimeMillis();
                if (now >= endTime) {
                    throw new TimeoutException("timeout reached while joining on: " + thread);
                }
                thread.join(endTime - now);
            }
        }
    }

    public static void joinFor(Clock clock, Thread thread, Object timeout) throws InterruptedException, TimeoutException {
        ConcurrentUtils.joinUntil(clock, thread, ClockUtils.toEndTime(timeout));
    }

    private ConcurrentUtils() {
    }
}

