/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.telemetry.listeners.sflow.proto.headers;

import com.google.common.base.Throwables;
import java.net.Inet4Address;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import org.bson.BsonWriter;
import org.opennms.netmgt.telemetry.listeners.api.utils.BufferUtils;
import org.opennms.netmgt.telemetry.listeners.sflow.InvalidPacketException;

public class Inet4Header {
    public final int tos;
    public final int totalLength;
    public final int protocol;
    public final String srcAddress;
    public final String dstAddress;
    public final Integer srcPort;
    public final Integer dstPort;
    public final Integer tcpFlags;

    public Inet4Header(ByteBuffer buffer) throws InvalidPacketException {
        int version_ihl = BufferUtils.uint8((ByteBuffer)buffer);
        if (version_ihl >> 4 != 4) {
            throw new InvalidPacketException(buffer, "Expected IPv4 Header", new Object[0]);
        }
        int ihl = (version_ihl & 0xF) * 4;
        this.tos = BufferUtils.uint8((ByteBuffer)buffer);
        this.totalLength = BufferUtils.uint16((ByteBuffer)buffer);
        BufferUtils.skip((ByteBuffer)buffer, (int)2);
        BufferUtils.skip((ByteBuffer)buffer, (int)2);
        BufferUtils.skip((ByteBuffer)buffer, (int)1);
        this.protocol = BufferUtils.uint8((ByteBuffer)buffer);
        BufferUtils.skip((ByteBuffer)buffer, (int)2);
        try {
            this.srcAddress = Inet4Address.getByAddress(BufferUtils.bytes((ByteBuffer)buffer, (int)4)).getHostAddress();
            this.dstAddress = Inet4Address.getByAddress(BufferUtils.bytes((ByteBuffer)buffer, (int)4)).getHostAddress();
        }
        catch (UnknownHostException e) {
            throw Throwables.propagate((Throwable)e);
        }
        BufferUtils.skip((ByteBuffer)buffer, (int)(ihl - 20));
        switch (this.protocol) {
            case 6: {
                this.srcPort = BufferUtils.uint16((ByteBuffer)buffer);
                this.dstPort = BufferUtils.uint16((ByteBuffer)buffer);
                BufferUtils.skip((ByteBuffer)buffer, (int)8);
                this.tcpFlags = BufferUtils.uint16((ByteBuffer)buffer) & 0x1FF;
                break;
            }
            case 17: 
            case 132: {
                this.srcPort = BufferUtils.uint16((ByteBuffer)buffer);
                this.dstPort = BufferUtils.uint16((ByteBuffer)buffer);
                this.tcpFlags = null;
                break;
            }
            case 1: 
            case 58: {
                this.srcPort = 0;
                this.dstPort = BufferUtils.uint16((ByteBuffer)buffer);
                this.tcpFlags = null;
                break;
            }
            default: {
                this.srcPort = null;
                this.dstPort = null;
                this.tcpFlags = null;
            }
        }
    }

    public void writeBson(BsonWriter bsonWriter) {
        bsonWriter.writeStartDocument();
        bsonWriter.writeInt32("tos", this.tos);
        bsonWriter.writeInt32("length", this.totalLength);
        bsonWriter.writeInt32("protocol", this.protocol);
        bsonWriter.writeString("src_ip", this.srcAddress);
        bsonWriter.writeString("dst_ip", this.dstAddress);
        if (this.srcPort != null) {
            bsonWriter.writeInt32("src_port", this.srcPort.intValue());
        }
        if (this.dstPort != null) {
            bsonWriter.writeInt32("dst_port", this.dstPort.intValue());
        }
        if (this.tcpFlags != null) {
            bsonWriter.writeInt32("tcp_flags", this.tcpFlags.intValue());
        }
        bsonWriter.writeEndDocument();
    }
}

