/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.telemetry.listeners.sflow.proto.flows;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.Optional;
import org.bson.BsonWriter;
import org.opennms.netmgt.telemetry.listeners.api.utils.BufferUtils;
import org.opennms.netmgt.telemetry.listeners.sflow.InvalidPacketException;
import org.opennms.netmgt.telemetry.listeners.sflow.proto.Opaque;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Record<T> {
    private static final Logger LOG = LoggerFactory.getLogger(Record.class);
    public final DataFormat dataFormat;
    public final Opaque<T> data;

    public Record(ByteBuffer buffer, Map<DataFormat, Opaque.Parser<T>> dataFormats) throws InvalidPacketException {
        this.dataFormat = new DataFormat(buffer);
        Opaque.Parser<T> parser = dataFormats.get(this.dataFormat);
        if (parser != null) {
            this.data = new Opaque<T>(buffer, Optional.empty(), parser);
        } else {
            LOG.debug("Unknown record type: {}:{}", (Object)this.dataFormat.enterpriseNumber, (Object)this.dataFormat.formatNumber);
            System.out.println("Unknown record type: " + this.dataFormat.enterpriseNumber + " / " + this.dataFormat.formatNumber);
            this.data = new Opaque<Object>(buffer, Optional.empty(), Opaque::parseUnknown);
        }
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("dataFormat", (Object)this.dataFormat).add("data", this.data).toString();
    }

    public abstract void writeBson(BsonWriter var1);

    public static class DataFormat {
        private final int enterpriseNumber;
        private final int formatNumber;

        protected DataFormat(int enterpriseNumber, int formatNumber) {
            this.enterpriseNumber = enterpriseNumber;
            this.formatNumber = formatNumber;
        }

        public DataFormat(ByteBuffer buffer) throws InvalidPacketException {
            int dataFormat = (int)BufferUtils.uint32((ByteBuffer)buffer);
            this.enterpriseNumber = dataFormat >> 12 & 0xFFFFF;
            this.formatNumber = dataFormat & 0xFFF;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DataFormat dataFormat = (DataFormat)o;
            return this.enterpriseNumber == dataFormat.enterpriseNumber && this.formatNumber == dataFormat.formatNumber;
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.enterpriseNumber, this.formatNumber});
        }

        public static DataFormat from(int formatNumber) {
            return new DataFormat(0, formatNumber);
        }

        public static DataFormat from(int enterpriseNumber, int formatNumber) {
            return new DataFormat(enterpriseNumber, formatNumber);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("enterpriseNumber", this.enterpriseNumber).add("formatNumber", this.formatNumber).toString();
        }

        public String toId() {
            return String.format("%s:%s", this.enterpriseNumber, this.formatNumber);
        }

        protected byte[] toBytes() {
            int dataFormat = this.enterpriseNumber << 12 | this.formatNumber & 0xFFF;
            return ByteBuffer.allocate(4).putInt(0, dataFormat).array();
        }
    }
}

