/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.telemetry.listeners.sflow.proto.flows;

import com.google.common.base.MoreObjects;
import java.nio.ByteBuffer;
import org.bson.BsonWriter;
import org.opennms.netmgt.telemetry.listeners.api.utils.BufferUtils;
import org.opennms.netmgt.telemetry.listeners.sflow.InvalidPacketException;

public enum MachineType {
    unknown(0),
    other(1),
    x86(2),
    x86_64(3),
    ia64(4),
    sparc(5),
    alpha(6),
    powerpc(7),
    m68k(8),
    mips(9),
    arm(10),
    hppa(11),
    s390(12);

    public final int value;

    private MachineType(int value) {
        this.value = value;
    }

    public static MachineType from(ByteBuffer buffer) throws InvalidPacketException {
        int value = (int)BufferUtils.uint32((ByteBuffer)buffer);
        switch (value) {
            case 0: {
                return unknown;
            }
            case 1: {
                return other;
            }
            case 2: {
                return x86;
            }
            case 3: {
                return x86_64;
            }
            case 4: {
                return ia64;
            }
            case 5: {
                return sparc;
            }
            case 6: {
                return alpha;
            }
            case 7: {
                return powerpc;
            }
            case 8: {
                return m68k;
            }
            case 9: {
                return mips;
            }
            case 10: {
                return arm;
            }
            case 11: {
                return hppa;
            }
            case 12: {
                return s390;
            }
        }
        throw new InvalidPacketException(buffer, "Unknown value: {}", value);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("value", this.value).toString();
    }

    public void writeBson(BsonWriter bsonWriter) {
        bsonWriter.writeInt32(this.value);
    }
}

