/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.telemetry.listeners.sflow.proto.flows;

import com.google.common.base.MoreObjects;
import java.nio.ByteBuffer;
import org.bson.BsonWriter;
import org.opennms.netmgt.telemetry.listeners.api.utils.BufferUtils;
import org.opennms.netmgt.telemetry.listeners.sflow.InvalidPacketException;

public enum HttpMethod {
    OTHER(0),
    OPTIONS(1),
    GET(2),
    HEAD(3),
    POST(4),
    PUT(5),
    DELETE(6),
    TRACE(7),
    CONNECT(8);

    public final int value;

    private HttpMethod(int value) {
        this.value = value;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("value", this.value).toString();
    }

    public static HttpMethod from(ByteBuffer buffer) throws InvalidPacketException {
        int value = (int)BufferUtils.uint32((ByteBuffer)buffer);
        switch (value) {
            case 0: {
                return OTHER;
            }
            case 1: {
                return OPTIONS;
            }
            case 2: {
                return GET;
            }
            case 3: {
                return HEAD;
            }
            case 4: {
                return POST;
            }
            case 5: {
                return PUT;
            }
            case 6: {
                return DELETE;
            }
            case 7: {
                return TRACE;
            }
            case 8: {
                return CONNECT;
            }
        }
        throw new InvalidPacketException(buffer, "Unknown value: {}", value);
    }

    public void writeBson(BsonWriter bsonWriter) {
        bsonWriter.writeInt32(this.value);
    }
}

