/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.telemetry.listeners.sflow.proto.flows;

import com.google.common.base.MoreObjects;
import java.nio.ByteBuffer;
import org.bson.BsonWriter;
import org.opennms.netmgt.telemetry.listeners.api.utils.BufferUtils;
import org.opennms.netmgt.telemetry.listeners.sflow.InvalidPacketException;
import org.opennms.netmgt.telemetry.listeners.sflow.proto.flows.FlowData;
import org.opennms.netmgt.telemetry.listeners.sflow.proto.flows.IpV6;

public class ExtendedSocketIpv6
implements FlowData {
    public final long protocol;
    public final IpV6 local_ip;
    public final IpV6 remote_ip;
    public final long local_port;
    public final long remote_port;

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("protocol", this.protocol).add("local_ip", (Object)this.local_ip).add("remote_ip", (Object)this.remote_ip).add("local_port", this.local_port).add("remote_port", this.remote_port).toString();
    }

    public ExtendedSocketIpv6(ByteBuffer buffer) throws InvalidPacketException {
        this.protocol = BufferUtils.uint32((ByteBuffer)buffer);
        this.local_ip = new IpV6(buffer);
        this.remote_ip = new IpV6(buffer);
        this.local_port = BufferUtils.uint32((ByteBuffer)buffer);
        this.remote_port = BufferUtils.uint32((ByteBuffer)buffer);
    }

    @Override
    public void writeBson(BsonWriter bsonWriter) {
        bsonWriter.writeStartDocument();
        bsonWriter.writeInt64("protocol", this.protocol);
        bsonWriter.writeName("local_ip");
        this.local_ip.writeBson(bsonWriter);
        bsonWriter.writeName("remote_ip");
        this.remote_ip.writeBson(bsonWriter);
        bsonWriter.writeInt64("local_port", this.local_port);
        bsonWriter.writeInt64("remote_port", this.remote_port);
        bsonWriter.writeEndDocument();
    }
}

