/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.telemetry.listeners.sflow.proto.flows;

import com.google.common.base.MoreObjects;
import java.nio.ByteBuffer;
import java.util.Optional;
import org.bson.BsonWriter;
import org.opennms.netmgt.telemetry.listeners.api.utils.BufferUtils;
import org.opennms.netmgt.telemetry.listeners.sflow.InvalidPacketException;
import org.opennms.netmgt.telemetry.listeners.sflow.proto.Array;
import org.opennms.netmgt.telemetry.listeners.sflow.proto.flows.AsPathType;
import org.opennms.netmgt.telemetry.listeners.sflow.proto.flows.FlowData;
import org.opennms.netmgt.telemetry.listeners.sflow.proto.flows.NextHop;

public class ExtendedGateway
implements FlowData {
    public final NextHop nexthop;
    public final long as;
    public final long src_as;
    public final long src_peer_as;
    public final Array<AsPathType> dst_as_path;
    public final Array<Long> communities;
    public final long localpref;

    public ExtendedGateway(ByteBuffer buffer) throws InvalidPacketException {
        this.nexthop = new NextHop(buffer);
        this.as = BufferUtils.uint32((ByteBuffer)buffer);
        this.src_as = BufferUtils.uint32((ByteBuffer)buffer);
        this.src_peer_as = BufferUtils.uint32((ByteBuffer)buffer);
        this.dst_as_path = new Array<Object>(buffer, Optional.empty(), AsPathType::new);
        this.communities = new Array<Object>(buffer, Optional.empty(), BufferUtils::uint32);
        this.localpref = BufferUtils.uint32((ByteBuffer)buffer);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("nexthop", (Object)this.nexthop).add("as", this.as).add("src_as", this.src_as).add("src_peer_as", this.src_peer_as).add("dst_as_path", this.dst_as_path).add("communities", this.communities).add("localpref", this.localpref).toString();
    }

    @Override
    public void writeBson(BsonWriter bsonWriter) {
        bsonWriter.writeStartDocument();
        bsonWriter.writeName("nexthop");
        this.nexthop.writeBson(bsonWriter);
        bsonWriter.writeInt64("as", this.as);
        bsonWriter.writeInt64("src_as", this.src_as);
        bsonWriter.writeInt64("src_peer_as", this.src_peer_as);
        bsonWriter.writeStartArray("dst_as_path");
        for (AsPathType asPathType : this.dst_as_path) {
            asPathType.writeBson(bsonWriter);
        }
        bsonWriter.writeEndArray();
        bsonWriter.writeStartArray("communities");
        for (Long longValue : this.communities) {
            bsonWriter.writeInt64(longValue.longValue());
        }
        bsonWriter.writeEndArray();
        bsonWriter.writeInt64("localpref", this.localpref);
        bsonWriter.writeEndDocument();
    }
}

