/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.telemetry.listeners.sflow.proto.flows;

import com.google.common.base.MoreObjects;
import java.nio.ByteBuffer;
import java.util.Optional;
import org.bson.BsonWriter;
import org.opennms.netmgt.telemetry.listeners.api.utils.BufferUtils;
import org.opennms.netmgt.telemetry.listeners.sflow.InvalidPacketException;
import org.opennms.netmgt.telemetry.listeners.sflow.proto.Array;
import org.opennms.netmgt.telemetry.listeners.sflow.proto.flows.CounterData;

public class BstPortBuffers
implements CounterData {
    public final Integer ingress_uc_pc;
    public final Integer ingress_mc_pc;
    public final Integer egress_uc_pc;
    public final Integer egress_mc_pc;
    public final Array<Integer> egress_queue_uc_pc;
    public final Array<Integer> egress_queue_mc_pc;

    public BstPortBuffers(ByteBuffer buffer) throws InvalidPacketException {
        this.ingress_uc_pc = BufferUtils.sint32((ByteBuffer)buffer);
        this.ingress_mc_pc = BufferUtils.sint32((ByteBuffer)buffer);
        this.egress_uc_pc = BufferUtils.sint32((ByteBuffer)buffer);
        this.egress_mc_pc = BufferUtils.sint32((ByteBuffer)buffer);
        this.egress_queue_uc_pc = new Array<Object>(buffer, Optional.of(8), BufferUtils::sint32);
        this.egress_queue_mc_pc = new Array<Object>(buffer, Optional.of(8), BufferUtils::sint32);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("ingress_uc_pc", (Object)this.ingress_uc_pc).add("ingress_mc_pc", (Object)this.ingress_mc_pc).add("egress_uc_pc", (Object)this.egress_uc_pc).add("egress_mc_pc", (Object)this.egress_mc_pc).add("egress_queue_uc_pc", this.egress_queue_uc_pc).add("egress_queue_mc_pc", this.egress_queue_mc_pc).toString();
    }

    @Override
    public void writeBson(BsonWriter bsonWriter) {
        bsonWriter.writeStartDocument();
        bsonWriter.writeInt32("ingress_uc_pc", this.ingress_uc_pc.intValue());
        bsonWriter.writeInt32("ingress_mc_pc", this.ingress_mc_pc.intValue());
        bsonWriter.writeInt32("egress_uc_pc", this.egress_uc_pc.intValue());
        bsonWriter.writeInt32("egress_mc_pc", this.egress_mc_pc.intValue());
        bsonWriter.writeStartArray("egress_queue_uc_pc");
        for (int i : this.egress_queue_uc_pc) {
            bsonWriter.writeInt32(i);
        }
        bsonWriter.writeEndArray();
        bsonWriter.writeStartArray("egress_queue_mc_pc");
        for (int i : this.egress_queue_mc_pc) {
            bsonWriter.writeInt32(i);
        }
        bsonWriter.writeEndArray();
        bsonWriter.writeEndDocument();
    }
}

