/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.telemetry.listeners.sflow.proto.flows;

import com.google.common.base.MoreObjects;
import com.google.common.primitives.UnsignedLong;
import java.nio.ByteBuffer;
import java.util.Optional;
import org.bson.BsonWriter;
import org.opennms.netmgt.telemetry.listeners.api.utils.BufferUtils;
import org.opennms.netmgt.telemetry.listeners.sflow.InvalidPacketException;
import org.opennms.netmgt.telemetry.listeners.sflow.proto.Array;
import org.opennms.netmgt.telemetry.listeners.sflow.proto.flows.Context;
import org.opennms.netmgt.telemetry.listeners.sflow.proto.flows.FlowData;
import org.opennms.netmgt.telemetry.listeners.sflow.proto.flows.Status;
import org.opennms.netmgt.telemetry.listeners.sflow.proto.flows.Utf8string;

public class AppOperation
implements FlowData {
    public final Context context;
    public final Array<Utf8string> status_descr;
    public final UnsignedLong req_bytes;
    public final UnsignedLong resp_bytes;
    public final long uS;
    public final Status status;

    public AppOperation(ByteBuffer buffer) throws InvalidPacketException {
        this.context = new Context(buffer);
        this.status_descr = new Array<Object>(buffer, Optional.empty(), Utf8string::new);
        this.req_bytes = BufferUtils.uint64((ByteBuffer)buffer);
        this.resp_bytes = BufferUtils.uint64((ByteBuffer)buffer);
        this.uS = BufferUtils.uint32((ByteBuffer)buffer);
        this.status = Status.from(buffer);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("context", (Object)this.context).add("status_descr", this.status_descr).add("req_bytes", (Object)this.req_bytes).add("resp_bytes", (Object)this.resp_bytes).add("uS", this.uS).add("", (Object)this.status).toString();
    }

    @Override
    public void writeBson(BsonWriter bsonWriter) {
        bsonWriter.writeStartDocument();
        bsonWriter.writeName("context");
        this.context.writeBson(bsonWriter);
        bsonWriter.writeStartArray("status_descr");
        for (Utf8string utf8string : this.status_descr) {
            utf8string.writeBson(bsonWriter);
        }
        bsonWriter.writeEndArray();
        bsonWriter.writeInt64("req_bytes", this.req_bytes.longValue());
        bsonWriter.writeInt64("resp_bytes", this.resp_bytes.longValue());
        bsonWriter.writeInt64("uS", this.uS);
        bsonWriter.writeName("status");
        this.status.writeBson(bsonWriter);
        bsonWriter.writeEndDocument();
    }
}

