/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.telemetry.listeners.flow.ie.values;

import com.google.common.base.MoreObjects;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.Optional;
import org.opennms.netmgt.telemetry.listeners.api.utils.BufferUtils;
import org.opennms.netmgt.telemetry.listeners.flow.ie.InformationElement;
import org.opennms.netmgt.telemetry.listeners.flow.ie.Semantics;
import org.opennms.netmgt.telemetry.listeners.flow.ie.Value;
import org.opennms.netmgt.telemetry.listeners.flow.session.Session;

public class StringValue
extends Value<String> {
    public static final Charset UTF8_CHARSET = Charset.forName("UTF-8");
    private final String value;

    public StringValue(String name, Optional<Semantics> semantics, String value) {
        super(name, semantics);
        this.value = value;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.getName()).add("value", (Object)this.value).toString();
    }

    public static InformationElement parser(final String name, final Optional<Semantics> semantics) {
        return new InformationElement(){

            @Override
            public Value<?> parse(Session.Resolver resolver, ByteBuffer buffer) {
                return new StringValue(name, semantics, new String(BufferUtils.bytes((ByteBuffer)buffer, (int)buffer.remaining()), UTF8_CHARSET));
            }

            @Override
            public String getName() {
                return name;
            }

            @Override
            public int getMinimumFieldLength() {
                return 0;
            }

            @Override
            public int getMaximumFieldLength() {
                return 65535;
            }
        };
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public void visit(Value.Visitor visitor) {
        visitor.accept(this);
    }
}

