/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.telemetry.listeners.flow.ie.values;

import com.google.common.base.MoreObjects;
import java.nio.ByteBuffer;
import java.util.Optional;
import org.opennms.netmgt.telemetry.listeners.api.utils.BufferUtils;
import org.opennms.netmgt.telemetry.listeners.flow.ie.InformationElement;
import org.opennms.netmgt.telemetry.listeners.flow.ie.Semantics;
import org.opennms.netmgt.telemetry.listeners.flow.ie.Value;
import org.opennms.netmgt.telemetry.listeners.flow.session.Session;

public class FloatValue
extends Value<Double> {
    private final double value;

    public FloatValue(String name, Optional<Semantics> semantics, double value) {
        super(name, semantics);
        this.value = value;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.getName()).add("value", this.value).toString();
    }

    public static InformationElement parserWith32Bit(final String name, final Optional<Semantics> semantics) {
        return new InformationElement(){

            @Override
            public Value<?> parse(Session.Resolver resolver, ByteBuffer buffer) {
                return new FloatValue(name, semantics, Float.intBitsToFloat(BufferUtils.uint((ByteBuffer)buffer, (int)buffer.remaining()).intValue()));
            }

            @Override
            public String getName() {
                return name;
            }

            @Override
            public int getMinimumFieldLength() {
                return 0;
            }

            @Override
            public int getMaximumFieldLength() {
                return 4;
            }
        };
    }

    public static InformationElement parserWith64Bit(final String name, final Optional<Semantics> semantics) {
        return new InformationElement(){

            @Override
            public Value<?> parse(Session.Resolver resolver, ByteBuffer buffer) {
                return new FloatValue(name, semantics, Double.longBitsToDouble(BufferUtils.uint((ByteBuffer)buffer, (int)buffer.remaining()).longValue()));
            }

            @Override
            public String getName() {
                return name;
            }

            @Override
            public int getMinimumFieldLength() {
                return 0;
            }

            @Override
            public int getMaximumFieldLength() {
                return 8;
            }
        };
    }

    @Override
    public Double getValue() {
        return this.value;
    }

    @Override
    public void visit(Value.Visitor visitor) {
        visitor.accept(this);
    }
}

