/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.telemetry.listeners.flow;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.FixedRecvByteBufAllocator;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.DatagramChannel;
import io.netty.channel.socket.nio.NioDatagramChannel;
import io.netty.util.concurrent.ScheduledFuture;
import io.netty.util.internal.SocketUtils;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import org.opennms.core.ipc.sink.api.AsyncDispatcher;
import org.opennms.netmgt.telemetry.listeners.api.Listener;
import org.opennms.netmgt.telemetry.listeners.api.TelemetryMessage;
import org.opennms.netmgt.telemetry.listeners.flow.PacketHandler;
import org.opennms.netmgt.telemetry.listeners.flow.Protocol;
import org.opennms.netmgt.telemetry.listeners.flow.session.UdpSessionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractUdpListener
implements Listener {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractUdpListener.class);
    public static final long HOUSEKEEPING_INTERVAL = 60000L;
    private final Protocol protocol;
    private String name;
    private String host = null;
    private int port = 4738;
    private Duration templateTimeout = Duration.ofMinutes(30L);
    private AsyncDispatcher<TelemetryMessage> dispatcher;
    private EventLoopGroup bossGroup;
    private ChannelFuture socketFuture;
    private UdpSessionManager sessionManager;
    private ScheduledFuture<?> housekeepingFuture;
    private int maxPacketSize = 8096;

    protected abstract ChannelHandler buildDecoder(UdpSessionManager var1);

    protected AbstractUdpListener(Protocol protocol) {
        this.protocol = protocol;
    }

    public void start() throws InterruptedException {
        this.sessionManager = new UdpSessionManager(this.templateTimeout);
        this.bossGroup = new NioEventLoopGroup();
        this.housekeepingFuture = this.bossGroup.scheduleAtFixedRate(this.sessionManager::doHousekeeping, 60000L, 60000L, TimeUnit.MILLISECONDS);
        InetSocketAddress address = this.host != null ? SocketUtils.socketAddress((String)this.host, (int)this.port) : new InetSocketAddress(this.port);
        this.socketFuture = ((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().group(this.bossGroup)).channel(NioDatagramChannel.class)).option(ChannelOption.SO_REUSEADDR, (Object)true)).option(ChannelOption.SO_RCVBUF, (Object)Integer.MAX_VALUE)).option(ChannelOption.RCVBUF_ALLOCATOR, (Object)new FixedRecvByteBufAllocator(this.maxPacketSize))).handler((ChannelHandler)new ChannelInitializer<DatagramChannel>(){

            protected void initChannel(final DatagramChannel ch) throws Exception {
                ch.pipeline().addLast(new ChannelHandler[]{AbstractUdpListener.this.buildDecoder(AbstractUdpListener.this.sessionManager)}).addLast(new ChannelHandler[]{new PacketHandler(AbstractUdpListener.this.protocol, (AsyncDispatcher<TelemetryMessage>)AbstractUdpListener.this.dispatcher)}).addLast(new ChannelHandler[]{new ChannelInboundHandlerAdapter(){

                    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
                        LOG.warn("Invalid packet: {}", (Object)cause.getMessage());
                        LOG.debug("", cause);
                        AbstractUdpListener.this.sessionManager.drop(ch.remoteAddress(), ch.localAddress());
                    }
                }});
            }
        })).bind((SocketAddress)address).sync();
    }

    public void stop() throws InterruptedException {
        LOG.info("Closing channel...");
        this.socketFuture.channel().close().sync();
        this.housekeepingFuture.cancel(false);
        LOG.info("Closing boss group...");
        this.bossGroup.shutdownGracefully().sync();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public int getMaxPacketSize() {
        return this.maxPacketSize;
    }

    public void setMaxPacketSize(int maxPacketSize) {
        this.maxPacketSize = maxPacketSize;
    }

    public Duration getTemplateTimeout() {
        return this.templateTimeout;
    }

    public void setTemplateTimeout(Duration templateTimeout) {
        this.templateTimeout = templateTimeout;
    }

    public void setDispatcher(AsyncDispatcher<TelemetryMessage> dispatcher) {
        this.dispatcher = dispatcher;
    }
}

