/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.events.api;

import java.math.BigInteger;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import org.opennms.core.utils.Base64;
import org.opennms.netmgt.snmp.SnmpObjId;
import org.opennms.netmgt.snmp.SnmpValue;
import org.opennms.netmgt.xml.event.Value;

public abstract class EventConstants {
    public static final String POSTGRES_DATE_FORMAT = "'Dy Mon DD HH24:MI:SS Tz YYYY'";
    public static final String SITUATION_EVENT_UEI = "uei.opennms.org/alarms/situation";
    public static final String NEW_SUSPECT_INTERFACE_EVENT_UEI = "uei.opennms.org/internal/discovery/newSuspect";
    public static final String DISC_PAUSE_EVENT_UEI = "uei.opennms.org/internal/capsd/discPause";
    public static final String DISC_RESUME_EVENT_UEI = "uei.opennms.org/internal/capsd/discResume";
    public static final String DISCOVERYCONFIG_CHANGED_EVENT_UEI = "uei.opennms.org/internal/discoveryConfigChange";
    public static final String ADD_NODE_EVENT_UEI = "uei.opennms.org/internal/capsd/addNode";
    public static final String DELETE_NODE_EVENT_UEI = "uei.opennms.org/internal/capsd/deleteNode";
    public static final String DELETE_INTERFACE_EVENT_UEI = "uei.opennms.org/internal/capsd/deleteInterface";
    public static final String OUTAGE_CREATED_EVENT_UEI = "uei.opennms.org/internal/poller/outageCreated";
    public static final String OUTAGE_RESOLVED_EVENT_UEI = "uei.opennms.org/internal/poller/outageResolved";
    public static final String NODE_ADDED_EVENT_UEI = "uei.opennms.org/nodes/nodeAdded";
    public static final String NODE_UPDATED_EVENT_UEI = "uei.opennms.org/nodes/nodeUpdated";
    public static final String NODE_CATEGORY_MEMBERSHIP_CHANGED_EVENT_UEI = "uei.opennms.org/nodes/nodeCategoryMembershipChanged";
    public static final String NODE_GAINED_INTERFACE_EVENT_UEI = "uei.opennms.org/nodes/nodeGainedInterface";
    public static final String NODE_GAINED_SERVICE_EVENT_UEI = "uei.opennms.org/nodes/nodeGainedService";
    public static final String NODE_LOST_SERVICE_EVENT_UEI = "uei.opennms.org/nodes/nodeLostService";
    public static final String SERVICE_RESPONSIVE_EVENT_UEI = "uei.opennms.org/nodes/serviceResponsive";
    public static final String SERVICE_UNRESPONSIVE_EVENT_UEI = "uei.opennms.org/nodes/serviceUnresponsive";
    public static final String SERVICE_UNMANAGED_EVENT_UEI = "uei.opennms.org/nodes/serviceUnmanaged";
    public static final String INTERFACE_DOWN_EVENT_UEI = "uei.opennms.org/nodes/interfaceDown";
    public static final String SNMP_INTERFACE_OPER_DOWN_EVENT_UEI = "uei.opennms.org/nodes/snmp/interfaceOperDown";
    public static final String SNMP_INTERFACE_ADMIN_DOWN_EVENT_UEI = "uei.opennms.org/nodes/snmp/interfaceAdminDown";
    public static final String NODE_DOWN_EVENT_UEI = "uei.opennms.org/nodes/nodeDown";
    public static final String PATH_OUTAGE_EVENT_UEI = "uei.opennms.org/nodes/pathOutage";
    public static final String NODE_UP_EVENT_UEI = "uei.opennms.org/nodes/nodeUp";
    public static final String INTERFACE_UP_EVENT_UEI = "uei.opennms.org/nodes/interfaceUp";
    public static final String SNMP_INTERFACE_OPER_UP_EVENT_UEI = "uei.opennms.org/nodes/snmp/interfaceOperUp";
    public static final String SNMP_INTERFACE_ADMIN_UP_EVENT_UEI = "uei.opennms.org/nodes/snmp/interfaceAdminUp";
    public static final String NODE_REGAINED_SERVICE_EVENT_UEI = "uei.opennms.org/nodes/nodeRegainedService";
    public static final String DELETE_SERVICE_EVENT_UEI = "uei.opennms.org/nodes/deleteService";
    public static final String SERVICE_DELETED_EVENT_UEI = "uei.opennms.org/nodes/serviceDeleted";
    public static final String INTERFACE_DELETED_EVENT_UEI = "uei.opennms.org/nodes/interfaceDeleted";
    public static final String NODE_DELETED_EVENT_UEI = "uei.opennms.org/nodes/nodeDeleted";
    public static final String LOW_THRESHOLD_EVENT_UEI = "uei.opennms.org/threshold/lowThresholdExceeded";
    public static final String HIGH_THRESHOLD_EVENT_UEI = "uei.opennms.org/threshold/highThresholdExceeded";
    public static final String HIGH_THRESHOLD_REARM_EVENT_UEI = "uei.opennms.org/threshold/highThresholdRearmed";
    public static final String LOW_THRESHOLD_REARM_EVENT_UEI = "uei.opennms.org/threshold/lowThresholdRearmed";
    public static final String RELATIVE_CHANGE_THRESHOLD_EVENT_UEI = "uei.opennms.org/threshold/relativeChangeExceeded";
    public static final String ABSOLUTE_CHANGE_THRESHOLD_EVENT_UEI = "uei.opennms.org/threshold/absoluteChangeExceeded";
    public static final String REARMING_ABSOLUTE_CHANGE_EXCEEDED_EVENT_UEI = "uei.opennms.org/threshold/rearmingAbsoluteChangeExceeded";
    public static final String REARMING_ABSOLUTE_CHANGE_REARM_EVENT_UEI = "uei.opennms.org/threshold/rearmingAbsoluteChangeRearmed";
    public static final String INTERFACE_REPARENTED_EVENT_UEI = "uei.opennms.org/nodes/interfaceReparented";
    public static final String NODE_INFO_CHANGED_EVENT_UEI = "uei.opennms.org/nodes/nodeInfoChanged";
    public static final String NODE_LABEL_CHANGED_EVENT_UEI = "uei.opennms.org/nodes/nodeLabelChanged";
    public static final String DUP_NODE_DELETED_EVENT_UEI = "uei.opennms.org/nodes/duplicateNodeDeleted";
    public static final String PRIMARY_SNMP_INTERFACE_CHANGED_EVENT_UEI = "uei.opennms.org/nodes/primarySnmpInterfaceChanged";
    public static final String REINITIALIZE_PRIMARY_SNMP_INTERFACE_EVENT_UEI = "uei.opennms.org/nodes/reinitializePrimarySnmpInterface";
    public static final String CONFIGURE_SNMP_EVENT_UEI = "uei.opennms.org/internal/configureSNMP";
    public static final String DATA_COLLECTION_FAILED_EVENT_UEI = "uei.opennms.org/nodes/dataCollectionFailed";
    public static final String DATA_COLLECTION_SUCCEEDED_EVENT_UEI = "uei.opennms.org/nodes/dataCollectionSucceeded";
    public static final String FORCE_RESCAN_EVENT_UEI = "uei.opennms.org/internal/capsd/forceRescan";
    public static final String SUSPEND_POLLING_SERVICE_EVENT_UEI = "uei.opennms.org/internal/poller/suspendPollingService";
    public static final String RESUME_POLLING_SERVICE_EVENT_UEI = "uei.opennms.org/internal/poller/resumePollingService";
    public static final String RESCAN_COMPLETED_EVENT_UEI = "uei.opennms.org/internal/capsd/rescanCompleted";
    public static final String RTC_SUBSCRIBE_EVENT_UEI = "uei.opennms.org/internal/rtc/subscribe";
    public static final String RTC_UNSUBSCRIBE_EVENT_UEI = "uei.opennms.org/internal/rtc/unsubscribe";
    public static final String PROMOTE_QUEUE_DATA_UEI = "uei.opennms.org/internal/promoteQueueData";
    public static final String NOTIFICATION_WITHOUT_USERS = "uei.opennms.org/internal/notificationWithoutUsers";
    public static final String ASSET_INFO_CHANGED_EVENT_UEI = "uei.opennms.org/nodes/assetInfoChanged";
    public static final String SCHEDOUTAGES_CHANGED_EVENT_UEI = "uei.opennms.org/internal/schedOutagesChanged";
    public static final String THRESHOLDCONFIG_CHANGED_EVENT_UEI = "uei.opennms.org/internal/thresholdConfigChange";
    public static final String EVENTSCONFIG_CHANGED_EVENT_UEI = "uei.opennms.org/internal/eventsConfigChange";
    public static final String SNMPPOLLERCONFIG_CHANGED_EVENT_UEI = "uei.opennms.org/internal/reloadSnmpPollerConfig";
    public static final String RELOAD_VACUUMD_CONFIG_UEI = "uei.opennms.org/internal/reloadVacuumdConfig";
    public static final String RELOAD_TOPOLOGY_UEI = "uei.opennms.org/internal/reloadTopology";
    public static final String RELOAD_DAEMON_CONFIG_UEI = "uei.opennms.org/internal/reloadDaemonConfig";
    public static final String RELOAD_DAEMON_CONFIG_FAILED_UEI = "uei.opennms.org/internal/reloadDaemonConfigFailed";
    public static final String RELOAD_DAEMON_CONFIG_SUCCESSFUL_UEI = "uei.opennms.org/internal/reloadDaemonConfigSuccessful";
    public static final String PARM_DAEMON_NAME = "daemonName";
    public static final String PARM_CONFIG_FILE_NAME = "configFile";
    public static final String REPORTD_RUN_REPORT = "uei.opennms.org/reportd/runReport";
    public static final String PARM_REPORT_NAME = "reportName";
    public static final String REPORT_RUN_FAILED_UEI = "uei.opennms.org/reportd/reportRunFailed";
    public static final String REPORT_DELIVERY_FAILED_UEI = "uei.opennms.org/reportd/reportDeliveryFailed";
    public static final String REMOTE_NODE_LOST_SERVICE_UEI = "uei.opennms.org/remote/nodes/nodeLostService";
    public static final String REMOTE_NODE_REGAINED_SERVICE_UEI = "uei.opennms.org/remote/nodes/nodeRegainedService";
    public static final String LOCATION_MONITOR_REGISTERED_UEI = "uei.opennms.org/remote/locationMonitorRegistered";
    public static final String LOCATION_MONITOR_STARTED_UEI = "uei.opennms.org/remote/locationMonitorStarted";
    public static final String LOCATION_MONITOR_STOPPED_UEI = "uei.opennms.org/remote/locationMonitorStopped";
    public static final String LOCATION_MONITOR_PAUSED_UEI = "uei.opennms.org/remote/locationMonitorPaused";
    public static final String LOCATION_MONITOR_DISCONNECTED_UEI = "uei.opennms.org/remote/locationMonitorDisconnected";
    public static final String LOCATION_MONITOR_RECONNECTED_UEI = "uei.opennms.org/remote/locationMonitorReconnected";
    public static final String LOCATION_MONITOR_CONNECTION_ADDRESS_CHANGED_UEI = "uei.opennms.org/remote/locationMonitorConnectionAddressChanged";
    public static final String REMOTE_SUCCESSFUL_SCAN_REPORT_UEI = "uei.opennms.org/remote/successfulScanReport";
    public static final String REMOTE_UNSUCCESSFUL_SCAN_REPORT_UEI = "uei.opennms.org/remote/unsuccessfulScanReport";
    public static final String RELOAD_IMPORT_UEI = "uei.opennms.org/internal/importer/reloadImport";
    public static final String IMPORT_STARTED_UEI = "uei.opennms.org/internal/importer/importStarted";
    public static final String IMPORT_SUCCESSFUL_UEI = "uei.opennms.org/internal/importer/importSuccessful";
    public static final String IMPORT_FAILED_UEI = "uei.opennms.org/internal/importer/importFailed";
    public static final String PROVISIONING_ADAPTER_FAILED = "uei.opennms.org/provisioner/provisioningAdapterFailed";
    public static final String PROVISION_SCAN_COMPLETE_UEI = "uei.opennms.org/internal/provisiond/nodeScanCompleted";
    public static final String PROVISION_SCAN_ABORTED_UEI = "uei.opennms.org/internal/provisiond/nodeScanAborted";
    public static final String PARM_FAILURE_MESSAGE = "failureMessage";
    public static final String PARM_IMPORT_STATS = "importStats";
    public static final String PARM_IMPORT_RESOURCE = "importResource";
    public static final String PARM_IMPORT_RESCAN_EXISTING = "importRescanExisting";
    public static final String PARM_ALARM_ID = "alarmId";
    public static final String PARM_ALARM_UEI = "alarmUei";
    public static final String PARM_ALARM_REDUCTION_KEY = "alarmReductionKey";
    public static final String PARM_TROUBLE_TICKET = "troubleTicket";
    public static final String TROUBLETICKET_CREATE_UEI = "uei.opennms.org/troubleTicket/create";
    public static final String TROUBLETICKET_UPDATE_UEI = "uei.opennms.org/troubleTicket/update";
    public static final String TROUBLETICKET_CLOSE_UEI = "uei.opennms.org/troubleTicket/close";
    public static final String TROUBLETICKET_CANCEL_UEI = "uei.opennms.org/troubleTicket/cancel";
    public static final String TL1_AUTONOMOUS_MESSAGE_UEI = "uei.opennms.org/api/tl1d/message/autonomous";
    public static final String RANCID_DOWNLOAD_SUCCESS_UEI = "uei.opennms.org/standard/rancid/traps/rancidTrapDownloadSuccess";
    public static final String RANCID_DOWNLOAD_FAILURE_UEI = "uei.opennms.org/standard/rancid/traps/rancidTrapDownloadFailure";
    public static final String RANCID_GROUP_PROCESSING_COMPLETED_UEI = "uei.opennms.org/standard/rancid/traps/rancidTrapGroupProcessingCompleted";
    public static final String TOPOLOGY_LINK_DOWN_EVENT_UEI = "uei.opennms.org/internal/topology/linkDown";
    public static final String TOPOLOGY_LINK_UP_EVENT_UEI = "uei.opennms.org/internal/topology/linkUp";
    public static final String HARDWARE_INVENTORY_FAILED_UEI = "uei.opennms.org/internal/discovery/hardwareInventoryFailed";
    public static final String HARDWARE_INVENTORY_SUCCESSFUL_UEI = "uei.opennms.org/internal/discovery/hardwareInventorySuccessful";
    public static final String KSC_REPORT_UPDATED_UEI = "uei.opennms.org/internal/kscReportUpdated";
    public static final String PARAM_REPORT_TITLE = "reportTitle";
    public static final String PARAM_REPORT_GRAPH_COUNT = "graphCount";
    public static final String MONITORING_SYSTEM_ADDED_UEI = "uei.opennms.org/internal/monitoringSystemAdded";
    public static final String MONITORING_SYSTEM_LOCATION_CHANGED_UEI = "uei.opennms.org/internal/monitoringSystemLocationChanged";
    public static final String MONITORING_SYSTEM_DELETED_UEI = "uei.opennms.org/internal/monitoringSystemDeleted";
    public static final String PARAM_MONITORING_SYSTEM_TYPE = "monitoringSystemType";
    public static final String PARAM_MONITORING_SYSTEM_ID = "monitoringSystemId";
    public static final String PARAM_MONITORING_SYSTEM_LOCATION = "monitoringSystemLocation";
    public static final String PARAM_MONITORING_SYSTEM_PREV_LOCATION = "monitoringSystemPreviousLocation";
    public static final String PARAM_TOPOLOGY_NAMESPACE = "namespace";
    public static final String PARM_CRITICAL_PATH_IP = "criticalPathIp";
    public static final String PARM_CRITICAL_PATH_SVC = "criticalPathServiceName";
    public static final String PARM_CRITICAL_PATH_NOTICE_SUPRESSED = "noticeSupressed";
    public static final String PARM_NODE_SYSNAME = "nodesysname";
    public static final String PARM_NODE_SYSDESCRIPTION = "nodesysdescription";
    public static final String PARM_NODE_SYSOID = "nodesysoid";
    public static final String PARM_NODE_SYSLOCATION = "nodesyslocation";
    public static final String PARM_NODE_SYSCONTACT = "nodesyscontact";
    public static final String PARM_IP_HOSTNAME = "iphostname";
    public static final String PARM_OLD_IP_HOSTNAME = "oldiphostname";
    public static final String PARM_METHOD = "method";
    public static final String PARM_INTERFACE = "interface";
    public static final String PARM_ACTION = "action";
    public static final String PARM_DPNAME = "dpName";
    public static final String PARM_OLD_NODEID = "oldNodeID";
    public static final String PARM_NEW_NODEID = "newNodeID";
    public static final String PARM_OLD_IFINDEX = "oldIfIndex";
    public static final String PARM_NEW_IFINDEX = "newIfIndex";
    public static final String PARM_NODE_LABEL = "nodelabel";
    public static final String PARM_NODE_LABEL_SOURCE = "nodelabelsource";
    public static final String PARM_OLD_NODE_LABEL = "oldNodeLabel";
    public static final String PARM_OLD_NODE_LABEL_SOURCE = "oldNodeLabelSource";
    public static final String PARM_NEW_NODE_LABEL = "newNodeLabel";
    public static final String PARM_NEW_NODE_LABEL_SOURCE = "newNodeLabelSource";
    public static final String PARM_NODE_NETBIOS_NAME = "nodenetbiosname";
    public static final String PARM_NODE_DOMAIN_NAME = "nodedomainname";
    public static final String PARM_NODE_OPERATING_SYSTEM = "nodeoperatingsystem";
    public static final String PARM_OLD_PRIMARY_SNMP_ADDRESS = "oldPrimarySnmpAddress";
    public static final String PARM_NEW_PRIMARY_SNMP_ADDRESS = "newPrimarySnmpAddress";
    public static final String PARM_SNMP_SECURITY_NAME = "securityName";
    public static final String PARM_SNMP_SECURITY_LEVEL = "securityLevel";
    public static final String PARM_SNMP_AUTH_PASSPHRASE = "authPassphrase";
    public static final String PARM_SNMP_AUTH_PROTOCOL = "authProtocol";
    public static final String PARM_SNMP_ENGINE_ID = "engineId";
    public static final String PARM_SNMP_CONTEXT_ENGINE_ID = "contextEngineId";
    public static final String PARM_SNMP_ENTERPRISE_ID = "enterpriseId";
    public static final String PARM_SNMP_CONTEXT_NAME = "contextName";
    public static final String PARM_SNMP_PRIVACY_PASSPHRASE = "privPassphrase";
    public static final String PARM_SNMP_PRIVACY_PROTOCOL = "privProtocol";
    public static final String PARM_SNMP_MAX_REPETITIONS = "maxRepetitions";
    public static final String PARM_SNMP_MAX_REQUEST_SIZE = "maxRequestSize";
    public static final String PARM_SNMP_MAX_VARS_PER_PDU = "maxVarsPerPdu";
    public static final String PARM_SNMP_PROXY_HOST = "proxyHost";
    public static final String PARM_FIRST_IP_ADDRESS = "firstIPAddress";
    public static final String PARM_LAST_IP_ADDRESS = "lastIPAddress";
    @Deprecated
    public static final String PARM_COMMUNITY_STRING = "communityString";
    public static final String PARM_SNMP_READ_COMMUNITY_STRING = "readCommunityString";
    public static final String PARM_SNMP_WRITE_COMMUNITY_STRING = "writeCommunityString";
    public static final String PARM_SNMP_LOCATION = "location";
    public static final String PARM_QUALIFIER = "qualifier";
    public static final String PARM_URL = "url";
    public static final String PARM_CAT_LABEL = "catlabel";
    public static final String PARM_CATEGORIES_ADDED = "categoriesAdded";
    public static final String PARM_CATEGORIES_DELETED = "categoriesDeleted";
    public static final String PARM_USER = "user";
    public static final String PARM_PASSWD = "passwd";
    public static final String PARM_SERVICE_STATUS = "serviceStatus";
    public static final String PARM_TRANSACTION_NO = "txno";
    public static final String PARM_LOSTSERVICE_REASON = "eventReason";
    public static final String PARM_VALUE_PATHOUTAGE = "pathOutage";
    public static final String PARM_PASSIVE_NODE_LABEL = "passiveNodeLabel";
    public static final String PARM_PASSIVE_IPADDR = "passiveIpAddr";
    public static final String PARM_PASSIVE_SERVICE_NAME = "passiveServiceName";
    public static final String PARM_PASSIVE_SERVICE_STATUS = "passiveStatus";
    public static final String PARM_PASSIVE_REASON_CODE = "passiveReasonCode";
    public static final String PARM_FOREIGN_SOURCE = "foreignSource";
    public static final String PARM_FOREIGN_ID = "foreignId";
    public static final String PARM_RESCAN_EXISTING = "rescanExisting";
    public static final String PARM_VERSION = "version";
    public static final String PARM_TIMEOUT = "timeout";
    public static final String PARM_RETRY_COUNT = "retryCount";
    public static final String PARM_PORT = "port";
    public static final String PARM_LOCATION_MONITOR_ID = "locationMonitorId";
    public static final String PARM_LOCATION = "location";
    public static final String PARM_FILES_TO_PROMOTE = "filesToPromote";
    public static final String PARM_SNMP_INTERFACE_IFINDEX = "snmpifindex";
    public static final String PARM_SNMP_INTERFACE_IP = "ipaddr";
    public static final String PARM_SNMP_INTERFACE_NAME = "snmpifname";
    public static final String PARM_SNMP_INTERFACE_DESC = "snmpifdescr";
    public static final String PARM_SNMP_INTERFACE_ALIAS = "snmpifalias";
    public static final String PARM_SNMP_INTERFACE_MASK = "mask";
    public static final int STATE_ON = 1;
    static final int STATE_OFF = 0;
    public static final String ACKNOWLEDGE_EVENT_UEI = "uei.opennms.org/ackd/acknowledge";
    public static final String NODE_CONFIG_CHANGE_UEI = "uei.opennms.org/internal/translator/entityConfigChanged";
    public static final String PARM_REASON = "reason";
    public static final String PARM_ENDPOINT1 = "endPoint1";
    public static final String PARM_ENDPOINT2 = "endPoint2";
    public static final String BUSINESS_SERVICE_OPERATIONAL_STATUS_CHANGED_UEI = "uei.opennms.org/bsm/serviceOperationalStatusChanged";
    public static final String BUSINESS_SERVICE_PROBLEM_UEI = "uei.opennms.org/bsm/serviceProblem";
    public static final String BUSINESS_SERVICE_PROBLEM_RESOLVED_UEI = "uei.opennms.org/bsm/serviceProblemResolved";
    public static final String PARM_BUSINESS_SERVICE_ID = "businessServiceId";
    public static final String PARM_BUSINESS_SERVICE_NAME = "businessServiceName";
    public static final String PARM_NEW_SEVERITY_ID = "newSeverityId";
    public static final String PARM_NEW_SEVERITY_LABEL = "newSeverityLabel";
    public static final String PARM_PREV_SEVERITY_ID = "prevSeverityId";
    public static final String PARM_PREV_SEVERITY_LABEL = "prevSeverityLabel";
    public static final String COMPONENT_ADDED_UEI = "uei.opennms.org/internal/ncs/componentAdded";
    public static final String COMPONENT_DELETED_UEI = "uei.opennms.org/internal/ncs/componentDeleted";
    public static final String COMPONENT_UPDATED_UEI = "uei.opennms.org/internal/ncs/componentUpdated";
    public static final String TYPE_STRING = "string";
    public static final String TYPE_INT = "int";
    public static final String TYPE_SNMP_OCTET_STRING = "OctetString";
    public static final String TYPE_SNMP_INT32 = "Int32";
    public static final String TYPE_SNMP_NULL = "Null";
    public static final String TYPE_SNMP_OBJECT_IDENTIFIER = "ObjectIdentifier";
    public static final String TYPE_SNMP_IPADDRESS = "IpAddress";
    public static final String TYPE_SNMP_TIMETICKS = "TimeTicks";
    public static final String TYPE_SNMP_COUNTER32 = "Counter32";
    public static final String TYPE_SNMP_GAUGE32 = "Gauge32";
    public static final String TYPE_SNMP_OPAQUE = "Opaque";
    public static final String TYPE_SNMP_SEQUENCE = "Sequence";
    public static final String TYPE_SNMP_COUNTER64 = "Counter64";
    public static final String XML_ENCODING_TEXT = "text";
    public static final String XML_ENCODING_BASE64 = "base64";
    public static final String XML_ENCODING_MAC_ADDRESS = "macAddress";
    public static final SnmpObjId OID_SNMP_IFINDEX = SnmpObjId.get((String)".1.3.6.1.2.1.2.2.1.1");
    public static final ThreadLocal<DateFormat> FORMATTER_FULL = new ThreadLocal<DateFormat>(){

        @Override
        protected synchronized DateFormat initialValue() {
            int timeFormat = 0;
            if (Locale.getDefault().getLanguage().equals(Locale.FRANCE.getLanguage())) {
                timeFormat = 1;
            } else if (Locale.getDefault().getLanguage().equals(Locale.GERMANY.getLanguage())) {
                timeFormat = 1;
            }
            DateFormat formatter = DateFormat.getDateTimeInstance(0, timeFormat);
            formatter.setLenient(true);
            return formatter;
        }
    };
    public static final ThreadLocal<DateFormat> FORMATTER_LONG = new ThreadLocal<DateFormat>(){

        @Override
        protected synchronized DateFormat initialValue() {
            DateFormat formatter = DateFormat.getDateTimeInstance(0, 1);
            formatter.setLenient(true);
            return formatter;
        }
    };
    public static final ThreadLocal<DateFormat> FORMATTER_FULL_GMT = new ThreadLocal<DateFormat>(){

        @Override
        protected synchronized DateFormat initialValue() {
            int timeFormat = 0;
            if (Locale.getDefault().getLanguage().equals(Locale.FRANCE.getLanguage())) {
                timeFormat = 1;
            } else if (Locale.getDefault().getLanguage().equals(Locale.GERMANY.getLanguage())) {
                timeFormat = 1;
            }
            DateFormat formatter = DateFormat.getDateTimeInstance(0, timeFormat);
            formatter.setLenient(true);
            formatter.setTimeZone(TimeZone.getTimeZone("GMT"));
            return formatter;
        }
    };
    public static final ThreadLocal<DateFormat> FORMATTER_LONG_GMT = new ThreadLocal<DateFormat>(){

        @Override
        protected synchronized DateFormat initialValue() {
            DateFormat formatter = DateFormat.getDateTimeInstance(0, 1);
            formatter.setLenient(true);
            formatter.setTimeZone(TimeZone.getTimeZone("GMT"));
            return formatter;
        }
    };
    public static final ThreadLocal<DateFormat> FORMATTER_CUSTOM = new ThreadLocal<DateFormat>(){

        @Override
        protected synchronized DateFormat initialValue() {
            SimpleDateFormat formatter = new SimpleDateFormat("EEEEE, d MMMMM yyyy k:mm:ss 'o''clock' z", Locale.ENGLISH);
            formatter.setLenient(true);
            return formatter;
        }
    };
    public static final ThreadLocal<DateFormat> FORMATTER_DEFAULT = new ThreadLocal<DateFormat>(){

        @Override
        protected synchronized DateFormat initialValue() {
            DateFormat formatter = DateFormat.getDateTimeInstance();
            formatter.setLenient(true);
            return formatter;
        }
    };

    public static final Date parseToDate(String timeString) throws ParseException {
        if (timeString == null) {
            throw new ParseException("time was null!", -1);
        }
        try {
            return FORMATTER_LONG.get().parse(timeString);
        }
        catch (ParseException parseException) {
            try {
                return FORMATTER_CUSTOM.get().parse(timeString);
            }
            catch (ParseException pe) {
                return FORMATTER_FULL.get().parse(timeString);
            }
        }
    }

    public static final String formatToString(Date date) {
        return FORMATTER_LONG_GMT.get().format(date);
    }

    public static String getValueAsString(Value pvalue) {
        if (pvalue == null) {
            return null;
        }
        if (pvalue.getContent() == null) {
            return null;
        }
        String result = "";
        String encoding = pvalue.getEncoding();
        if (encoding.equals(XML_ENCODING_TEXT)) {
            result = pvalue.getContent();
        } else if (encoding.equals(XML_ENCODING_BASE64)) {
            byte[] bytes = Base64.decodeBase64((char[])pvalue.getContent().toCharArray());
            result = "0x" + EventConstants.toHexString(bytes);
        } else if (encoding.equals(XML_ENCODING_MAC_ADDRESS)) {
            result = pvalue.getContent();
        } else {
            throw new IllegalStateException("Unknown encoding for parm value: " + encoding);
        }
        return result.trim();
    }

    public static String toHexString(byte[] data) {
        StringBuilder b = new StringBuilder();
        for (int i = 0; i < data.length; ++i) {
            int x = data[i] & 0xFF;
            if (x < 16) {
                b.append("0");
            }
            b.append(Integer.toString(x, 16).toLowerCase());
        }
        return b.toString();
    }

    public static String toString(String encoding, Object value) {
        if (encoding == null || value == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        String result = null;
        if (XML_ENCODING_TEXT.equals(encoding)) {
            if (value instanceof String) {
                result = (String)value;
            } else if (value instanceof Number) {
                result = value.toString();
            } else if (value instanceof SnmpValue) {
                result = ((SnmpValue)value).toString();
            }
        } else if (XML_ENCODING_BASE64.equals(encoding)) {
            if (value instanceof String) {
                result = new String(Base64.encodeBase64((byte[])((String)value).getBytes()));
            } else if (value instanceof Number) {
                byte[] ibuf = null;
                ibuf = value instanceof BigInteger ? ((BigInteger)value).toByteArray() : BigInteger.valueOf(((Number)value).longValue()).toByteArray();
                result = new String(Base64.encodeBase64((byte[])ibuf));
            } else if (value instanceof SnmpValue) {
                SnmpValue snmpValue = (SnmpValue)value;
                result = new String(Base64.encodeBase64((byte[])snmpValue.getBytes()));
            }
        } else if (XML_ENCODING_MAC_ADDRESS.equals(encoding) && value instanceof SnmpValue) {
            SnmpValue snmpValue = (SnmpValue)value;
            StringBuilder macAddress = new StringBuilder();
            byte[] bytes = snmpValue.getBytes();
            for (int i = 0; i < bytes.length; ++i) {
                if (i > 0) {
                    macAddress.append(":");
                }
                macAddress.append(String.format("%02X", bytes[i]));
            }
            result = macAddress.toString();
        }
        if (result == null) {
            throw new IllegalArgumentException("unable to encode " + value + " of type " + value.getClass());
        }
        return result;
    }
}

