/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.telemetry.distributed.common;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.xml.bind.JAXB;
import org.opennms.netmgt.telemetry.config.api.Package;
import org.opennms.netmgt.telemetry.config.api.Protocol;
import org.opennms.netmgt.telemetry.distributed.common.MapUtils;

public class MapBasedProtocolDef
implements Protocol {
    private final String name;
    private final Optional<Integer> threads;
    private final Optional<Integer> queueSize;
    private final Optional<Integer> batchSize;
    private final Optional<Integer> batchInterval;

    public MapBasedProtocolDef(Map<String, String> parameters) {
        this.name = MapUtils.getRequiredString("name", parameters);
        this.threads = MapUtils.getOptionalInteger("threads", parameters);
        this.queueSize = MapUtils.getOptionalInteger("queue.size", parameters);
        this.batchSize = MapUtils.getOptionalInteger("batch.size", parameters);
        this.batchInterval = MapUtils.getOptionalInteger("batch.interval", parameters);
    }

    public String getName() {
        return this.name;
    }

    public Optional<Integer> getNumThreads() {
        return this.threads;
    }

    public Optional<Integer> getBatchSize() {
        return this.batchSize;
    }

    public Optional<Integer> getBatchIntervalMs() {
        return this.batchInterval;
    }

    public Optional<Integer> getQueueSize() {
        return this.queueSize;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<? extends Package> getPackages() {
        try (InputStream inputStream = this.getClass().getResourceAsStream("/package.xml");){
            org.opennms.netmgt.telemetry.config.model.Package pkg = (org.opennms.netmgt.telemetry.config.model.Package)JAXB.unmarshal((InputStream)inputStream, org.opennms.netmgt.telemetry.config.model.Package.class);
            ArrayList arrayList = Lists.newArrayList((Object[])new org.opennms.netmgt.telemetry.config.model.Package[]{pkg});
            return arrayList;
        }
        catch (IOException e) {
            throw new RuntimeException("Error while reading package.xml", e);
        }
    }
}

