/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.telemetry.distributed.common;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.opennms.netmgt.telemetry.config.api.Adapter;
import org.opennms.netmgt.telemetry.distributed.common.MapBasedAdapterDef;
import org.opennms.netmgt.telemetry.distributed.common.MapUtils;

public class AdapterConfigurationParser {
    public List<Adapter> parse(Map<String, String> properties) {
        if (!this.hasAdaptersKey(properties)) {
            return Lists.newArrayList((Object[])new Adapter[]{new MapBasedAdapterDef(properties)});
        }
        Map<String, String> adapterConfigurations = MapUtils.filterKeysByPrefix(properties, "adapters.");
        Set numbers = adapterConfigurations.keySet().stream().map(key -> key.split("\\.")[0]).sorted().collect(Collectors.toSet());
        ArrayList<Adapter> adapters = new ArrayList<Adapter>();
        for (String eachAdapterPrefix : numbers) {
            Map<String, String> stringStringMap = MapUtils.filterKeysByPrefix(adapterConfigurations, eachAdapterPrefix + ".");
            MapBasedAdapterDef mapBasedAdapterDef = new MapBasedAdapterDef(stringStringMap);
            adapters.add(mapBasedAdapterDef);
        }
        return adapters;
    }

    private boolean hasAdaptersKey(Map<String, String> properties) {
        return properties.keySet().stream().filter(key -> key.startsWith("adapters.")).findAny().isPresent();
    }
}

