/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.ipc.sink.common;

import com.codahale.metrics.JmxReporter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.MetricSet;
import com.codahale.metrics.Timer;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Objects;
import org.opennms.core.ipc.sink.aggregation.AggregatingSinkMessageProducer;
import org.opennms.core.ipc.sink.api.AsyncDispatcher;
import org.opennms.core.ipc.sink.api.Message;
import org.opennms.core.ipc.sink.api.MessageDispatcherFactory;
import org.opennms.core.ipc.sink.api.SinkModule;
import org.opennms.core.ipc.sink.api.SyncDispatcher;
import org.opennms.core.ipc.sink.common.AsyncDispatcherImpl;
import org.opennms.core.ipc.sink.common.DispatcherState;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

public abstract class AbstractMessageDispatcherFactory<W>
implements MessageDispatcherFactory {
    private final MetricRegistry metrics = new MetricRegistry();
    private JmxReporter metricsJmxRepoter = null;
    private ServiceRegistration<MetricSet> metricsServiceRegistration = null;

    public abstract <S extends Message, T extends Message> void dispatch(SinkModule<S, T> var1, W var2, T var3);

    public abstract String getMetricDomain();

    public abstract BundleContext getBundleContext();

    private <S extends Message, T extends Message> void timedDispatch(DispatcherState<W, S, T> state, T message) {
        try (Timer.Context ctx = state.getDispatchTimer().time();){
            this.dispatch(state.getModule(), state.getMetaData(), message);
        }
    }

    public <S extends Message, T extends Message> W getModuleMetadata(SinkModule<S, T> module) {
        return null;
    }

    public <S extends Message, T extends Message> SyncDispatcher<S> createSyncDispatcher(SinkModule<S, T> module) {
        Objects.requireNonNull(module, "module cannot be null");
        DispatcherState state = new DispatcherState(this, module);
        return this.createSyncDispatcher(state);
    }

    public <S extends Message, T extends Message> AsyncDispatcher<S> createAsyncDispatcher(SinkModule<S, T> module) {
        Objects.requireNonNull(module, "module cannot be null");
        Objects.requireNonNull(module.getAsyncPolicy(), "module must have an AsyncPolicy");
        DispatcherState state = new DispatcherState(this, module);
        SyncDispatcher<S> syncDispatcher = this.createSyncDispatcher(state);
        return new AsyncDispatcherImpl(state, module.getAsyncPolicy(), syncDispatcher);
    }

    protected <S extends Message, T extends Message> SyncDispatcher<S> createSyncDispatcher(final DispatcherState<W, S, T> state) {
        SinkModule<S, T> module = state.getModule();
        if (module.getAggregationPolicy() != null) {
            return new AggregatingSinkMessageProducer<S, T>(module){

                @Override
                public void dispatch(T message) {
                    AbstractMessageDispatcherFactory.this.timedDispatch(state, message);
                }

                @Override
                public void close() throws Exception {
                    super.close();
                    state.close();
                }
            };
        }
        return new DirectDispatcher<S, T>(state);
    }

    protected MetricRegistry getMetrics() {
        return this.metrics;
    }

    public void onInit() {
        this.registerJmxReporterForMetrics();
        this.maybeRegisterMetricSetInServiceRegistry();
    }

    public void onDestroy() {
        this.unregisterJmxReporterForMetrics();
        this.unregisterMetricSetInServiceRegistry();
    }

    private void registerJmxReporterForMetrics() {
        this.metricsJmxRepoter = JmxReporter.forRegistry((MetricRegistry)this.getMetrics()).inDomain(this.getMetricDomain()).build();
        this.metricsJmxRepoter.start();
    }

    private void unregisterJmxReporterForMetrics() {
        if (this.metricsJmxRepoter != null) {
            this.metricsJmxRepoter.close();
            this.metricsJmxRepoter = null;
        }
    }

    private void maybeRegisterMetricSetInServiceRegistry() {
        BundleContext bundleContext = this.getBundleContext();
        if (bundleContext != null) {
            Hashtable<String, String> props = new Hashtable<String, String>();
            ((Dictionary)props).put("name", this.getMetricDomain());
            ((Dictionary)props).put("description", "Sink API Related Metrics for " + this.getMetricDomain());
            this.metricsServiceRegistration = bundleContext.registerService(MetricSet.class, (Object)this.getMetrics(), props);
        }
    }

    private void unregisterMetricSetInServiceRegistry() {
        if (this.metricsServiceRegistration != null) {
            this.metricsServiceRegistration.unregister();
            this.metricsServiceRegistration = null;
        }
    }

    private class DirectDispatcher<S extends Message, T extends Message>
    implements SyncDispatcher<S> {
        private final DispatcherState<W, S, T> state;

        public DirectDispatcher(DispatcherState<W, S, T> state) {
            this.state = state;
        }

        public void send(S message) {
            AbstractMessageDispatcherFactory.this.timedDispatch(this.state, message);
        }

        public void close() throws Exception {
            this.state.close();
        }
    }
}

