/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.snmp.proxy.common;

import java.util.Collections;
import java.util.List;
import org.opennms.netmgt.snmp.SnmpAgentConfig;
import org.opennms.netmgt.snmp.SnmpObjId;
import org.opennms.netmgt.snmp.SnmpResult;
import org.opennms.netmgt.snmp.SnmpValue;
import org.opennms.netmgt.snmp.proxy.common.AbstractSNMPRequestBuilder;
import org.opennms.netmgt.snmp.proxy.common.LocationAwareSnmpClientRpcImpl;
import org.opennms.netmgt.snmp.proxy.common.SnmpGetRequestDTO;
import org.opennms.netmgt.snmp.proxy.common.SnmpMultiResponseDTO;

public class SNMPSingleGetBuilder
extends AbstractSNMPRequestBuilder<SnmpValue> {
    public SNMPSingleGetBuilder(LocationAwareSnmpClientRpcImpl client, SnmpAgentConfig agent, SnmpObjId oid) {
        super(client, agent, SNMPSingleGetBuilder.buildGetRequests(oid), Collections.emptyList());
    }

    private static List<SnmpGetRequestDTO> buildGetRequests(SnmpObjId oid) {
        SnmpGetRequestDTO getRequest = new SnmpGetRequestDTO();
        getRequest.setOids(Collections.singletonList(oid));
        return Collections.singletonList(getRequest);
    }

    @Override
    protected SnmpValue processResponse(SnmpMultiResponseDTO response) {
        return response.getResponses().stream().flatMap(res -> res.getResults().stream()).findFirst().map(SnmpResult::getValue).orElse(null);
    }
}

