/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.ipc.sink.camel.client;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.camel.Endpoint;
import org.apache.camel.EndpointInject;
import org.apache.camel.ProducerTemplate;
import org.opennms.core.camel.JmsQueueNameFactory;
import org.opennms.core.ipc.sink.api.Message;
import org.opennms.core.ipc.sink.api.SinkModule;
import org.opennms.core.ipc.sink.camel.client.CamelLocalMessageDispatcherFactory;
import org.opennms.core.ipc.sink.common.AbstractMessageDispatcherFactory;
import org.osgi.framework.BundleContext;

public class CamelRemoteMessageDispatcherFactory
extends AbstractMessageDispatcherFactory<Map<String, Object>> {
    @EndpointInject(uri="direct:sendMessage", context="sinkClient")
    private ProducerTemplate template;
    @EndpointInject(uri="direct:sendMessage", context="sinkClient")
    private Endpoint endpoint;
    private BundleContext bundleContext;

    public <S extends Message, T extends Message> Map<String, Object> getModuleMetadata(SinkModule<S, T> module) {
        JmsQueueNameFactory queueNameFactory = new JmsQueueNameFactory("Sink", module.getId());
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("JmsQueueName", queueNameFactory.getName());
        return Collections.unmodifiableMap(headers);
    }

    public <S extends Message, T extends Message> void dispatch(SinkModule<S, T> module, Map<String, Object> headers, T message) {
        this.template.sendBodyAndHeaders(this.endpoint, (Object)module.marshal(message), headers);
    }

    public String getMetricDomain() {
        return CamelLocalMessageDispatcherFactory.class.getPackage().getName();
    }

    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    public void init() {
        this.onInit();
    }

    public void destroy() {
        this.onDestroy();
    }

    public void setBundleContext(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }
}

