/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.telemetry.listeners.flow.netflow9.proto;

import com.google.common.base.MoreObjects;
import java.nio.ByteBuffer;
import org.opennms.netmgt.telemetry.listeners.api.utils.BufferUtils;
import org.opennms.netmgt.telemetry.listeners.flow.InvalidPacketException;

public class Header {
    public static final int SIZE = 20;
    public static final int VERSION = 9;
    public final int versionNumber;
    public final int count;
    public final long sysUpTime;
    public final long unixSecs;
    public final long sequenceNumber;
    public final long sourceId;

    public Header(ByteBuffer buffer) throws InvalidPacketException {
        this.versionNumber = BufferUtils.uint16((ByteBuffer)buffer);
        if (this.versionNumber != 9) {
            throw new InvalidPacketException(buffer, "Invalid version number: 0x%04X", this.versionNumber);
        }
        this.count = BufferUtils.uint16((ByteBuffer)buffer);
        if (this.count <= 0) {
            throw new InvalidPacketException(buffer, "Empty packet", new Object[0]);
        }
        this.sysUpTime = BufferUtils.uint32((ByteBuffer)buffer);
        this.unixSecs = BufferUtils.uint32((ByteBuffer)buffer);
        this.sequenceNumber = BufferUtils.uint32((ByteBuffer)buffer);
        this.sourceId = BufferUtils.uint32((ByteBuffer)buffer);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("versionNumber", this.versionNumber).add("count", this.count).add("sysUpTime", this.sysUpTime).add("unixSecs", this.unixSecs).add("sequenceNumber", this.sequenceNumber).add("sourceId", this.sourceId).toString();
    }
}

