/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.telemetry.listeners.flow.ipfix.proto;

import com.google.common.base.MoreObjects;
import java.nio.ByteBuffer;
import org.opennms.netmgt.telemetry.listeners.api.utils.BufferUtils;
import org.opennms.netmgt.telemetry.listeners.flow.InvalidPacketException;

public final class Header {
    public static final int SIZE = 16;
    public static final int VERSION = 10;
    public final int versionNumber;
    public final int length;
    public final long exportTime;
    public final long sequenceNumber;
    public final long observationDomainId;

    public Header(ByteBuffer buffer) throws InvalidPacketException {
        this.versionNumber = BufferUtils.uint16((ByteBuffer)buffer);
        if (this.versionNumber != 10) {
            throw new InvalidPacketException(buffer, "Invalid version number: 0x%04X", this.versionNumber);
        }
        this.length = BufferUtils.uint16((ByteBuffer)buffer);
        if (this.length <= 0) {
            throw new InvalidPacketException(buffer, "Empty packet", new Object[0]);
        }
        this.exportTime = BufferUtils.uint32((ByteBuffer)buffer);
        this.sequenceNumber = BufferUtils.uint32((ByteBuffer)buffer);
        this.observationDomainId = BufferUtils.uint32((ByteBuffer)buffer);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("versionNumber", this.versionNumber).add("length", this.length).add("exportTime", this.exportTime).add("sequenceNumber", this.sequenceNumber).add("observationDomainId", this.observationDomainId).toString();
    }
}

