/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.telemetry.listeners.flow.ipfix.proto;

import com.google.common.base.MoreObjects;
import java.nio.ByteBuffer;
import org.opennms.netmgt.telemetry.listeners.api.utils.BufferUtils;
import org.opennms.netmgt.telemetry.listeners.flow.InvalidPacketException;

public final class FlowSetHeader {
    public static final int TEMPLATE_SET_ID = 2;
    public static final int OPTIONS_TEMPLATE_SET_ID = 3;
    public static final int SIZE = 4;
    public final int setId;
    public final int length;

    public FlowSetHeader(ByteBuffer buffer) throws InvalidPacketException {
        this.setId = BufferUtils.uint16((ByteBuffer)buffer);
        if (this.setId < 256 && this.setId != 2 && this.setId != 3) {
            throw new InvalidPacketException(buffer, "Invalid set ID: %d", this.setId);
        }
        this.length = BufferUtils.uint16((ByteBuffer)buffer);
    }

    public Type getType() {
        if (this.setId == 2) {
            return Type.TEMPLATE_SET;
        }
        if (this.setId == 3) {
            return Type.OPTIONS_TEMPLATE_SET;
        }
        if (this.setId >= 256) {
            return Type.DATA_SET;
        }
        return null;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("setId", this.setId).add("length", this.length).toString();
    }

    public static enum Type {
        TEMPLATE_SET,
        OPTIONS_TEMPLATE_SET,
        DATA_SET;

    }
}

