/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.telemetry.listeners.flow.ipfix.proto;

import com.google.common.base.MoreObjects;
import java.nio.ByteBuffer;
import java.util.Optional;
import org.opennms.netmgt.telemetry.listeners.api.utils.BufferUtils;
import org.opennms.netmgt.telemetry.listeners.flow.InvalidPacketException;
import org.opennms.netmgt.telemetry.listeners.flow.Protocol;
import org.opennms.netmgt.telemetry.listeners.flow.ie.InformationElement;
import org.opennms.netmgt.telemetry.listeners.flow.ie.InformationElementDatabase;
import org.opennms.netmgt.telemetry.listeners.flow.ie.Value;
import org.opennms.netmgt.telemetry.listeners.flow.ie.values.UndeclaredValue;
import org.opennms.netmgt.telemetry.listeners.flow.session.Field;
import org.opennms.netmgt.telemetry.listeners.flow.session.Scope;
import org.opennms.netmgt.telemetry.listeners.flow.session.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FieldSpecifier
implements Field,
Scope {
    private static final Logger LOG = LoggerFactory.getLogger(FieldSpecifier.class);
    public final int informationElementId;
    public final int fieldLength;
    public final Optional<Long> enterpriseNumber;
    public final InformationElement informationElement;

    public FieldSpecifier(ByteBuffer buffer) throws InvalidPacketException {
        int elementId = BufferUtils.uint16((ByteBuffer)buffer);
        this.informationElementId = elementId & Short.MAX_VALUE;
        this.fieldLength = BufferUtils.uint16((ByteBuffer)buffer);
        if ((elementId & 0x8000) == 0) {
            this.enterpriseNumber = Optional.empty();
        } else {
            long enterpriseNumber = BufferUtils.uint32((ByteBuffer)buffer);
            this.enterpriseNumber = Optional.of(enterpriseNumber);
        }
        this.informationElement = InformationElementDatabase.instance.lookup(Protocol.IPFIX, this.enterpriseNumber, this.informationElementId).orElseGet(() -> {
            LOG.warn("Undeclared information element: {}", (Object)UndeclaredValue.nameFor(this.enterpriseNumber, this.informationElementId));
            return UndeclaredValue.parser(this.enterpriseNumber, this.informationElementId);
        });
        if (this.fieldLength > this.informationElement.getMaximumFieldLength() || this.fieldLength < this.informationElement.getMinimumFieldLength()) {
            throw new InvalidPacketException(buffer, "Template field '%s' has illegal size: %d (min=%d, max=%d)", this.informationElement.getName(), this.fieldLength, this.informationElement.getMinimumFieldLength(), this.informationElement.getMaximumFieldLength());
        }
    }

    @Override
    public Value<?> parse(Session.Resolver resolver, ByteBuffer buffer) throws InvalidPacketException {
        return this.informationElement.parse(resolver, buffer);
    }

    @Override
    public int length() {
        return this.fieldLength;
    }

    @Override
    public String getName() {
        return this.informationElement.getName();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("informationElementId", this.informationElementId).add("enterpriseNumber", this.enterpriseNumber).add("fieldLength", this.fieldLength).toString();
    }
}

