/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.telemetry.listeners.flow.ipfix;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.util.internal.SocketUtils;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import org.opennms.core.ipc.sink.api.AsyncDispatcher;
import org.opennms.netmgt.telemetry.listeners.api.Listener;
import org.opennms.netmgt.telemetry.listeners.api.TelemetryMessage;
import org.opennms.netmgt.telemetry.listeners.flow.PacketHandler;
import org.opennms.netmgt.telemetry.listeners.flow.Protocol;
import org.opennms.netmgt.telemetry.listeners.flow.ipfix.TcpPacketDecoder;
import org.opennms.netmgt.telemetry.listeners.flow.ipfix.UdpListener;
import org.opennms.netmgt.telemetry.listeners.flow.session.TcpSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TcpListener
implements Listener {
    private static final Logger LOG = LoggerFactory.getLogger(TcpListener.class);
    private String name;
    private String host = null;
    private int port = 4739;
    private AsyncDispatcher<TelemetryMessage> dispatcher;
    private EventLoopGroup bossGroup;
    private EventLoopGroup workerGroup;
    private ChannelFuture socketFuture;

    public void start() throws InterruptedException {
        this.bossGroup = new NioEventLoopGroup();
        this.workerGroup = new NioEventLoopGroup();
        InetSocketAddress address = this.host != null ? SocketUtils.socketAddress((String)this.host, (int)this.port) : new InetSocketAddress(this.port);
        this.socketFuture = ((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)new ServerBootstrap().group(this.bossGroup, this.workerGroup).channel(NioServerSocketChannel.class)).option(ChannelOption.SO_REUSEADDR, (Object)true)).option(ChannelOption.SO_BACKLOG, (Object)128)).childOption(ChannelOption.SO_KEEPALIVE, (Object)true).childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            protected void initChannel(SocketChannel ch) {
                TcpSession session = new TcpSession();
                ch.pipeline().addLast(new ChannelHandler[]{new TcpPacketDecoder(ch.remoteAddress(), ch.localAddress(), session)}).addLast(new ChannelHandler[]{new PacketHandler(Protocol.IPFIX, (AsyncDispatcher<TelemetryMessage>)TcpListener.this.dispatcher)}).addLast(new ChannelHandler[]{new ChannelInboundHandlerAdapter(){

                    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
                        cause.printStackTrace();
                        LOG.warn("Invalid packet: {}", (Object)cause.getMessage());
                        LOG.debug("", cause);
                        ctx.close();
                    }
                }});
            }
        }).bind((SocketAddress)address).sync();
    }

    public void stop() throws InterruptedException {
        LOG.info("Closing channel...");
        this.socketFuture.channel().close().sync();
        LOG.info("Closing boss group...");
        this.bossGroup.shutdownGracefully().sync();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setDispatcher(AsyncDispatcher<TelemetryMessage> dispatcher) {
        this.dispatcher = dispatcher;
    }

    public static void main(String ... args) throws Exception {
        UdpListener l = new UdpListener();
        l.setName("sflow-test");
        l.start();
        while (true) {
            Thread.sleep(1000L);
        }
    }
}

