/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.telemetry.listeners.flow.ipfix;

import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVRecord;
import org.opennms.netmgt.telemetry.listeners.flow.Protocol;
import org.opennms.netmgt.telemetry.listeners.flow.ie.InformationElementDatabase;
import org.opennms.netmgt.telemetry.listeners.flow.ie.Semantics;
import org.opennms.netmgt.telemetry.listeners.flow.ie.values.BooleanValue;
import org.opennms.netmgt.telemetry.listeners.flow.ie.values.DateTimeValue;
import org.opennms.netmgt.telemetry.listeners.flow.ie.values.FloatValue;
import org.opennms.netmgt.telemetry.listeners.flow.ie.values.IPv4AddressValue;
import org.opennms.netmgt.telemetry.listeners.flow.ie.values.IPv6AddressValue;
import org.opennms.netmgt.telemetry.listeners.flow.ie.values.ListValue;
import org.opennms.netmgt.telemetry.listeners.flow.ie.values.MacAddressValue;
import org.opennms.netmgt.telemetry.listeners.flow.ie.values.OctetArrayValue;
import org.opennms.netmgt.telemetry.listeners.flow.ie.values.SignedValue;
import org.opennms.netmgt.telemetry.listeners.flow.ie.values.StringValue;
import org.opennms.netmgt.telemetry.listeners.flow.ie.values.UnsignedValue;

public class InformationElementProvider
implements InformationElementDatabase.Provider {
    private static final String COLUMN_ID = "ElementID";
    private static final String COLUMN_NAME = "Name";
    private static final String COLUMN_TYPE = "Abstract Data Type";
    private static final String COLUMN_SEMANTICS = "Data Type Semantics";
    private static final CSVFormat CSV_FORMAT = CSVFormat.newFormat((char)',').withQuote('\"').withEscape('\\').withFirstRecordAsHeader();
    private static final Map<String, Semantics> SEMANTICS_LOOKUP = ImmutableMap.builder().put((Object)"default", (Object)Semantics.DEFAULT).put((Object)"quantity", (Object)Semantics.QUANTITY).put((Object)"totalCounter", (Object)Semantics.TOTAL_COUNTER).put((Object)"deltaCounter", (Object)Semantics.DELTA_COUNTER).put((Object)"identifier", (Object)Semantics.IDENTIFIER).put((Object)"flags", (Object)Semantics.FLAGS).put((Object)"list", (Object)Semantics.LIST).put((Object)"snmpCounter", (Object)Semantics.SNMP_COUNTER).put((Object)"snmpGauge", (Object)Semantics.SNMP_GAUGE).build();
    private static final Map<String, InformationElementDatabase.ValueParserFactory> TYPE_LOOKUP = ImmutableMap.builder().put((Object)"octetArray", OctetArrayValue::parser).put((Object)"unsigned8", UnsignedValue::parserWith8Bit).put((Object)"unsigned16", UnsignedValue::parserWith16Bit).put((Object)"unsigned32", UnsignedValue::parserWith32Bit).put((Object)"unsigned64", UnsignedValue::parserWith64Bit).put((Object)"signed8", SignedValue::parserWith8Bit).put((Object)"signed16", SignedValue::parserWith16Bit).put((Object)"signed32", SignedValue::parserWith32Bit).put((Object)"signed64", SignedValue::parserWith64Bit).put((Object)"float32", FloatValue::parserWith32Bit).put((Object)"float64", FloatValue::parserWith64Bit).put((Object)"boolean", BooleanValue::parser).put((Object)"macAddress", MacAddressValue::parser).put((Object)"string", StringValue::parser).put((Object)"dateTimeSeconds", DateTimeValue::parserWithSeconds).put((Object)"dateTimeMilliseconds", DateTimeValue::parserWithMilliseconds).put((Object)"dateTimeMicroseconds", DateTimeValue::parserWithMicroseconds).put((Object)"dateTimeNanoseconds", DateTimeValue::parserWithNanoseconds).put((Object)"ipv4Address", IPv4AddressValue::parser).put((Object)"ipv6Address", IPv6AddressValue::parser).put((Object)"basicList", ListValue::parserWithBasicList).put((Object)"subTemplateList", ListValue::parserWithSubTemplateList).put((Object)"subTemplateMultiList", ListValue::parserWithSubTemplateMultiList).build();

    @Override
    public void load(InformationElementDatabase.Adder adder) {
        try (InputStreamReader r = new InputStreamReader(this.getClass().getResourceAsStream("/ipfix-information-elements.csv"));){
            for (CSVRecord record : CSV_FORMAT.parse((Reader)r)) {
                int id;
                try {
                    id = Integer.valueOf(record.get(COLUMN_ID));
                }
                catch (NumberFormatException e) {
                    continue;
                }
                String name = record.get(COLUMN_NAME);
                InformationElementDatabase.ValueParserFactory valueParserFactory = TYPE_LOOKUP.get(record.get(COLUMN_TYPE));
                if (valueParserFactory == null) continue;
                Optional<Semantics> semantics = Optional.ofNullable(SEMANTICS_LOOKUP.get(record.get(COLUMN_SEMANTICS)));
                adder.add(Protocol.IPFIX, id, valueParserFactory, name, semantics);
            }
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }
}

