/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.telemetry.listeners.flow.ie.values;

import com.google.common.base.MoreObjects;
import java.net.Inet4Address;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.util.Optional;
import org.opennms.netmgt.telemetry.listeners.api.utils.BufferUtils;
import org.opennms.netmgt.telemetry.listeners.flow.InvalidPacketException;
import org.opennms.netmgt.telemetry.listeners.flow.ie.InformationElement;
import org.opennms.netmgt.telemetry.listeners.flow.ie.Semantics;
import org.opennms.netmgt.telemetry.listeners.flow.ie.Value;
import org.opennms.netmgt.telemetry.listeners.flow.session.Session;

public class IPv4AddressValue
extends Value<Inet4Address> {
    public final Inet4Address value;

    public IPv4AddressValue(String name, Optional<Semantics> semantics, Inet4Address value) {
        super(name, semantics);
        this.value = value;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.getName()).add("inet4Address", (Object)this.value).toString();
    }

    public static InformationElement parser(final String name, final Optional<Semantics> semantics) {
        return new InformationElement(){

            @Override
            public Value<?> parse(Session.Resolver resolver, ByteBuffer buffer) throws InvalidPacketException {
                try {
                    return new IPv4AddressValue(name, semantics, (Inet4Address)Inet4Address.getByAddress(BufferUtils.bytes((ByteBuffer)buffer, (int)4)));
                }
                catch (UnknownHostException e) {
                    throw new InvalidPacketException(buffer, "Error parsing IPv4 value", e);
                }
            }

            @Override
            public String getName() {
                return name;
            }

            @Override
            public int getMinimumFieldLength() {
                return 4;
            }

            @Override
            public int getMaximumFieldLength() {
                return 4;
            }
        };
    }

    @Override
    public Inet4Address getValue() {
        return this.value;
    }

    @Override
    public void visit(Value.Visitor visitor) {
        visitor.accept(this);
    }
}

