/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.telemetry.listeners.flow.ie;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.opennms.netmgt.telemetry.listeners.flow.Protocol;
import org.opennms.netmgt.telemetry.listeners.flow.ie.InformationElement;
import org.opennms.netmgt.telemetry.listeners.flow.ie.Semantics;
import org.opennms.netmgt.telemetry.listeners.flow.ie.values.NullValue;
import org.opennms.netmgt.telemetry.listeners.flow.netflow9.InformationElementProvider;

public class InformationElementDatabase {
    public static final InformationElementDatabase instance = new InformationElementDatabase(new org.opennms.netmgt.telemetry.listeners.flow.ipfix.InformationElementProvider(), new InformationElementProvider());
    private final Map<Key, InformationElement> elements;

    private InformationElementDatabase(Provider ... providers) {
        AdderImpl adder = new AdderImpl();
        adder.add(Protocol.NETFLOW9, 0, NullValue::parser, "null", Optional.empty());
        adder.add(Protocol.IPFIX, 0, NullValue::parser, "null", Optional.empty());
        for (Provider provider : providers) {
            provider.load(adder);
        }
        this.elements = adder.build();
    }

    public Optional<InformationElement> lookup(Protocol protocol, Optional<Long> enterpriseNumber, int informationElementIdentifier) {
        return Optional.ofNullable(this.elements.get(new Key(protocol, enterpriseNumber, informationElementIdentifier)));
    }

    public Optional<InformationElement> lookup(Protocol protocol, int informationElementIdentifier) {
        return this.lookup(protocol, Optional.empty(), informationElementIdentifier);
    }

    private static class AdderImpl
    implements Adder {
        private final ImmutableMap.Builder<Key, InformationElement> builder = ImmutableMap.builder();

        private AdderImpl() {
        }

        @Override
        public void add(Key key, InformationElement element) {
            Objects.requireNonNull(key);
            Objects.requireNonNull(element);
            this.builder.put((Object)key, (Object)element);
        }

        public Map<Key, InformationElement> build() {
            return this.builder.build();
        }
    }

    public static interface Provider {
        public void load(Adder var1);
    }

    public static interface Adder {
        public void add(Key var1, InformationElement var2);

        default public void add(Protocol protocol, Optional<Long> enterpriseNumber, int informationElementNumber, ValueParserFactory parserFactory, String name, Optional<Semantics> semantics) {
            this.add(new Key(protocol, enterpriseNumber, informationElementNumber), parserFactory.parser(name, semantics));
        }

        default public void add(Protocol protocol, int informationElementNumber, ValueParserFactory parserFactory, String name, Optional<Semantics> semantics) {
            this.add(protocol, Optional.empty(), informationElementNumber, parserFactory, name, semantics);
        }

        default public void add(Protocol protocol, int informationElementNumber, ValueParserFactory parserFactory, String name, Semantics semantics) {
            this.add(protocol, Optional.empty(), informationElementNumber, parserFactory, name, Optional.of(semantics));
        }
    }

    @FunctionalInterface
    public static interface ValueParserFactory {
        public InformationElement parser(String var1, Optional<Semantics> var2);
    }

    public static class Key {
        private final Protocol protocol;
        private final Optional<Long> enterpriseNumber;
        private final Integer informationElementIdentifier;

        public Key(Protocol protocol, Optional<Long> enterpriseNumber, Integer informationElementNumber) {
            this.protocol = Objects.requireNonNull(protocol);
            this.enterpriseNumber = Objects.requireNonNull(enterpriseNumber);
            this.informationElementIdentifier = Objects.requireNonNull(informationElementNumber);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Key that = (Key)o;
            return Objects.equals((Object)this.protocol, (Object)that.protocol) && Objects.equals(this.enterpriseNumber, that.enterpriseNumber) && Objects.equals(this.informationElementIdentifier, that.informationElementIdentifier);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.protocol, this.enterpriseNumber, this.informationElementIdentifier});
        }
    }
}

