/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.threshd;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.opennms.core.xml.ValidateUsing;
import org.opennms.netmgt.config.threshd.Expression;
import org.opennms.netmgt.config.threshd.Threshold;
import org.opennms.netmgt.config.utils.ConfigUtils;

@XmlRootElement(name="group")
@XmlAccessorType(value=XmlAccessType.FIELD)
@ValidateUsing(value="thresholding.xsd")
public class Group
implements Serializable {
    private static final long serialVersionUID = 2L;
    @XmlAttribute(name="name", required=true)
    private String m_name;
    @XmlAttribute(name="rrdRepository", required=true)
    private String m_rrdRepository;
    @XmlElement(name="threshold")
    private List<Threshold> m_thresholds = new ArrayList<Threshold>();
    @XmlElement(name="expression")
    private List<Expression> m_expressions = new ArrayList<Expression>();

    public String getName() {
        return this.m_name;
    }

    public void setName(String name) {
        this.m_name = ConfigUtils.assertNotEmpty(name, "name");
    }

    public String getRrdRepository() {
        return this.m_rrdRepository;
    }

    public void setRrdRepository(String rrdRepository) {
        this.m_rrdRepository = ConfigUtils.assertNotEmpty(rrdRepository, "rrdRepository");
    }

    public List<Threshold> getThresholds() {
        return this.m_thresholds;
    }

    public void setThresholds(List<Threshold> thresholds) {
        if (thresholds == this.m_thresholds) {
            return;
        }
        this.m_thresholds.clear();
        if (thresholds != null) {
            this.m_thresholds.addAll(thresholds);
        }
    }

    public void addThreshold(Threshold threshold) {
        this.m_thresholds.add(threshold);
    }

    public boolean removeThreshold(Threshold threshold) {
        return this.m_thresholds.remove(threshold);
    }

    public List<Expression> getExpressions() {
        return this.m_expressions;
    }

    public void setExpressions(List<Expression> expressions) {
        if (expressions == this.m_expressions) {
            return;
        }
        this.m_expressions.clear();
        if (expressions != null) {
            this.m_expressions.addAll(expressions);
        }
    }

    public void addExpression(Expression expression) {
        this.m_expressions.add(expression);
    }

    public boolean removeExpression(Expression expression) {
        return this.m_expressions.remove(expression);
    }

    public int hashCode() {
        return Objects.hash(this.m_name, this.m_rrdRepository, this.m_thresholds, this.m_expressions);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Group) {
            Group that = (Group)obj;
            return Objects.equals(this.m_name, that.m_name) && Objects.equals(this.m_rrdRepository, that.m_rrdRepository) && Objects.equals(this.m_thresholds, that.m_thresholds) && Objects.equals(this.m_expressions, that.m_expressions);
        }
        return false;
    }
}

