/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.telemetry.listeners.sflow.proto.flows;

import com.google.common.base.MoreObjects;
import java.nio.ByteBuffer;
import org.bson.BsonWriter;
import org.opennms.netmgt.telemetry.listeners.sflow.InvalidPacketException;
import org.opennms.netmgt.telemetry.listeners.sflow.proto.flows.DatagramVersion;
import org.opennms.netmgt.telemetry.listeners.sflow.proto.flows.SampleDatagramV5;

public class SampleDatagramType {
    public final DatagramVersion version;
    public final SampleDatagramV5 datagram;

    public SampleDatagramType(ByteBuffer buffer) throws InvalidPacketException {
        this.version = DatagramVersion.from(buffer);
        switch (this.version) {
            case VERSION5: {
                this.datagram = new SampleDatagramV5(buffer);
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("version", (Object)this.version).add("datagram", (Object)this.datagram).toString();
    }

    public void writeBson(BsonWriter bsonWriter) {
        bsonWriter.writeStartDocument();
        bsonWriter.writeName("version");
        this.version.writeBson(bsonWriter);
        bsonWriter.writeName("datagram");
        this.datagram.writeBson(bsonWriter);
        bsonWriter.writeEndDocument();
    }
}

