/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.telemetry.listeners.sflow.proto.flows;

import com.google.common.base.MoreObjects;
import java.nio.ByteBuffer;
import org.bson.BsonWriter;
import org.opennms.netmgt.telemetry.listeners.api.utils.BufferUtils;
import org.opennms.netmgt.telemetry.listeners.sflow.InvalidPacketException;

public enum MemcacheStatus {
    UNKNOWN(0),
    OK(1),
    ERROR(2),
    CLIENT_ERROR(3),
    SERVER_ERROR(4),
    STORED(5),
    NOT_STORED(6),
    EXISTS(7),
    NOT_FOUND(8),
    DELETED(9);

    public final int value;

    private MemcacheStatus(int value) {
        this.value = value;
    }

    public static MemcacheStatus from(ByteBuffer buffer) throws InvalidPacketException {
        int value = (int)BufferUtils.uint32((ByteBuffer)buffer);
        switch (value) {
            case 0: {
                return UNKNOWN;
            }
            case 1: {
                return OK;
            }
            case 2: {
                return ERROR;
            }
            case 3: {
                return CLIENT_ERROR;
            }
            case 4: {
                return SERVER_ERROR;
            }
            case 5: {
                return STORED;
            }
            case 6: {
                return NOT_STORED;
            }
            case 7: {
                return EXISTS;
            }
            case 8: {
                return NOT_FOUND;
            }
            case 9: {
                return DELETED;
            }
        }
        throw new InvalidPacketException(buffer, "Unknown value: {}", value);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("value", this.value).toString();
    }

    public void writeBson(BsonWriter bsonWriter) {
        bsonWriter.writeInt32(this.value);
    }
}

