/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.telemetry.listeners.sflow.proto.flows;

import com.google.common.base.MoreObjects;
import com.google.common.base.Throwables;
import java.net.Inet6Address;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.util.Optional;
import org.bson.BsonWriter;
import org.opennms.netmgt.telemetry.listeners.sflow.InvalidPacketException;
import org.opennms.netmgt.telemetry.listeners.sflow.proto.Opaque;

public class IpV6 {
    public final Opaque<byte[]> ip_v6;

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("ip_v6", this.ip_v6).toString();
    }

    public IpV6(ByteBuffer buffer) throws InvalidPacketException {
        this.ip_v6 = new Opaque<Object>(buffer, Optional.of(16), Opaque::parseBytes);
    }

    public void writeBson(BsonWriter bsonWriter) {
        try {
            bsonWriter.writeString(Inet6Address.getByAddress((byte[])this.ip_v6.value).getHostAddress());
        }
        catch (UnknownHostException e) {
            Throwables.propagate((Throwable)e);
        }
    }
}

