/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.telemetry.listeners.sflow.proto.flows;

import com.google.common.base.MoreObjects;
import java.nio.ByteBuffer;
import org.bson.BsonWriter;
import org.opennms.netmgt.telemetry.listeners.api.utils.BufferUtils;
import org.opennms.netmgt.telemetry.listeners.sflow.InvalidPacketException;

public enum Ieee80211Version {
    a(1),
    b(2),
    g(3),
    n(4);

    public final int value;

    private Ieee80211Version(int value) {
        this.value = value;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("value", this.value).toString();
    }

    public static Ieee80211Version from(ByteBuffer buffer) throws InvalidPacketException {
        int value = (int)BufferUtils.uint32((ByteBuffer)buffer);
        switch (value) {
            case 1: {
                return a;
            }
            case 2: {
                return b;
            }
            case 3: {
                return g;
            }
            case 4: {
                return n;
            }
        }
        throw new InvalidPacketException(buffer, "Unknown value: {}", value);
    }

    public void writeBson(BsonWriter bsonWriter) {
        bsonWriter.writeInt32(this.value);
    }
}

