/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.telemetry.listeners.sflow.proto.flows;

import com.google.common.base.MoreObjects;
import com.google.common.primitives.UnsignedLong;
import java.nio.ByteBuffer;
import org.bson.BsonWriter;
import org.opennms.netmgt.telemetry.listeners.api.utils.BufferUtils;
import org.opennms.netmgt.telemetry.listeners.sflow.InvalidPacketException;
import org.opennms.netmgt.telemetry.listeners.sflow.proto.flows.CounterData;
import org.opennms.netmgt.telemetry.listeners.sflow.proto.flows.Percentage;

public class HostDiskIo
implements CounterData {
    public final UnsignedLong disk_total;
    public final UnsignedLong disk_free;
    public final Percentage part_max_used;
    public final long reads;
    public final UnsignedLong bytes_read;
    public final long read_time;
    public final long writes;
    public final UnsignedLong bytes_written;
    public final long write_time;

    public HostDiskIo(ByteBuffer buffer) throws InvalidPacketException {
        this.disk_total = BufferUtils.uint64((ByteBuffer)buffer);
        this.disk_free = BufferUtils.uint64((ByteBuffer)buffer);
        this.part_max_used = new Percentage(buffer);
        this.reads = BufferUtils.uint32((ByteBuffer)buffer);
        this.bytes_read = BufferUtils.uint64((ByteBuffer)buffer);
        this.read_time = BufferUtils.uint32((ByteBuffer)buffer);
        this.writes = BufferUtils.uint32((ByteBuffer)buffer);
        this.bytes_written = BufferUtils.uint64((ByteBuffer)buffer);
        this.write_time = BufferUtils.uint32((ByteBuffer)buffer);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("disk_total", (Object)this.disk_total).add("disk_free", (Object)this.disk_free).add("part_max_used", (Object)this.part_max_used).add("reads", this.reads).add("bytes_read", (Object)this.bytes_read).add("read_time", this.read_time).add("writes", this.writes).add("bytes_written", (Object)this.bytes_written).add("write_time", this.write_time).toString();
    }

    @Override
    public void writeBson(BsonWriter bsonWriter) {
        bsonWriter.writeStartDocument();
        bsonWriter.writeInt64("disk_total", this.disk_total.longValue());
        bsonWriter.writeInt64("disk_free", this.disk_free.longValue());
        bsonWriter.writeName("part_max_used");
        this.part_max_used.writeBson(bsonWriter);
        bsonWriter.writeInt64("reads", this.reads);
        bsonWriter.writeInt64("bytes_read", this.bytes_read.longValue());
        bsonWriter.writeInt64("read_time", this.read_time);
        bsonWriter.writeInt64("writes", this.writes);
        bsonWriter.writeInt64("bytes_written", this.bytes_written.longValue());
        bsonWriter.writeInt64("write_time", this.write_time);
        bsonWriter.writeEndDocument();
    }
}

