/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.telemetry.listeners.sflow.proto.flows;

import com.google.common.base.MoreObjects;
import java.nio.ByteBuffer;
import org.bson.BsonWriter;
import org.opennms.netmgt.telemetry.listeners.api.utils.BufferUtils;
import org.opennms.netmgt.telemetry.listeners.sflow.InvalidPacketException;

public enum HeaderProtocol {
    ETHERNET_ISO88023(1),
    ISO88024_TOKENBUS(2),
    ISO88025_TOKENRING(3),
    FDDI(4),
    FRAME_RELAY(5),
    X25(6),
    PPP(7),
    SMDS(8),
    AAL5(9),
    AAL5_IP(10),
    IPv4(11),
    IPv6(12),
    MPLS(13),
    POS(14),
    IEEE80211MAC(15),
    IEEE80211_AMPDU(16),
    IEEE80211_AMSDU_Subframe(17);

    public final int value;

    private HeaderProtocol(int value) {
        this.value = value;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("value", this.value).toString();
    }

    public static HeaderProtocol from(ByteBuffer buffer) throws InvalidPacketException {
        int value = (int)BufferUtils.uint32((ByteBuffer)buffer);
        switch (value) {
            case 1: {
                return ETHERNET_ISO88023;
            }
            case 2: {
                return ISO88024_TOKENBUS;
            }
            case 3: {
                return ISO88025_TOKENRING;
            }
            case 4: {
                return FDDI;
            }
            case 5: {
                return FRAME_RELAY;
            }
            case 6: {
                return X25;
            }
            case 7: {
                return PPP;
            }
            case 8: {
                return SMDS;
            }
            case 9: {
                return AAL5;
            }
            case 10: {
                return AAL5_IP;
            }
            case 11: {
                return IPv4;
            }
            case 12: {
                return IPv6;
            }
            case 13: {
                return MPLS;
            }
            case 14: {
                return POS;
            }
            case 15: {
                return IEEE80211MAC;
            }
            case 16: {
                return IEEE80211_AMPDU;
            }
            case 17: {
                return IEEE80211_AMSDU_Subframe;
            }
        }
        throw new InvalidPacketException(buffer, "Unknown value: {}", value);
    }

    public void writeBson(BsonWriter bsonWriter) {
        bsonWriter.writeInt32(this.value);
    }
}

