/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.telemetry.listeners.sflow.proto.flows;

import com.google.common.base.MoreObjects;
import java.nio.ByteBuffer;
import java.util.Optional;
import org.bson.BsonWriter;
import org.opennms.netmgt.telemetry.listeners.api.utils.BufferUtils;
import org.opennms.netmgt.telemetry.listeners.sflow.InvalidPacketException;
import org.opennms.netmgt.telemetry.listeners.sflow.proto.Array;
import org.opennms.netmgt.telemetry.listeners.sflow.proto.flows.FlowRecord;
import org.opennms.netmgt.telemetry.listeners.sflow.proto.flows.InterfaceExpanded;
import org.opennms.netmgt.telemetry.listeners.sflow.proto.flows.SampleData;
import org.opennms.netmgt.telemetry.listeners.sflow.proto.flows.SflowDataSourceExpanded;

public class FlowSampleExpanded
implements SampleData {
    public final long sequence_number;
    public final SflowDataSourceExpanded source_id;
    public final long sampling_rate;
    public final long sample_pool;
    public final long drops;
    public final InterfaceExpanded input;
    public final InterfaceExpanded output;
    public final Array<FlowRecord> flow_records;

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("sequence_number", this.sequence_number).add("source_id", (Object)this.source_id).add("sampling_rate", this.sampling_rate).add("sample_pool", this.sample_pool).add("drops", this.drops).add("input", (Object)this.input).add("output", (Object)this.output).add("flow_records", this.flow_records).toString();
    }

    public FlowSampleExpanded(ByteBuffer buffer) throws InvalidPacketException {
        this.sequence_number = BufferUtils.uint32((ByteBuffer)buffer);
        this.source_id = new SflowDataSourceExpanded(buffer);
        this.sampling_rate = BufferUtils.uint32((ByteBuffer)buffer);
        this.sample_pool = BufferUtils.uint32((ByteBuffer)buffer);
        this.drops = BufferUtils.uint32((ByteBuffer)buffer);
        this.input = new InterfaceExpanded(buffer);
        this.output = new InterfaceExpanded(buffer);
        this.flow_records = new Array<Object>(buffer, Optional.empty(), FlowRecord::new);
    }

    @Override
    public void writeBson(BsonWriter bsonWriter) {
        bsonWriter.writeStartDocument();
        bsonWriter.writeInt64("sequence_number", this.sequence_number);
        bsonWriter.writeName("source_id");
        this.source_id.writeBson(bsonWriter);
        bsonWriter.writeInt64("sampling_rate", this.sampling_rate);
        bsonWriter.writeInt64("sample_pool", this.sample_pool);
        bsonWriter.writeInt64("drops", this.drops);
        bsonWriter.writeName("input");
        this.input.writeBson(bsonWriter);
        bsonWriter.writeName("output");
        this.output.writeBson(bsonWriter);
        bsonWriter.writeStartDocument("flows");
        for (FlowRecord flowRecord : this.flow_records) {
            bsonWriter.writeName(flowRecord.dataFormat.toId());
            flowRecord.writeBson(bsonWriter);
        }
        bsonWriter.writeEndDocument();
        bsonWriter.writeEndDocument();
    }
}

