/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.telemetry.listeners.sflow.proto.flows;

import com.google.common.base.MoreObjects;
import java.nio.ByteBuffer;
import java.util.Optional;
import org.bson.BsonWriter;
import org.opennms.netmgt.telemetry.listeners.api.utils.BufferUtils;
import org.opennms.netmgt.telemetry.listeners.sflow.InvalidPacketException;
import org.opennms.netmgt.telemetry.listeners.sflow.proto.Array;
import org.opennms.netmgt.telemetry.listeners.sflow.proto.flows.CounterRecord;
import org.opennms.netmgt.telemetry.listeners.sflow.proto.flows.SampleData;
import org.opennms.netmgt.telemetry.listeners.sflow.proto.flows.SflowDataSource;

public class CountersSample
implements SampleData {
    public final long sequence_number;
    public final SflowDataSource source_id;
    public final Array<CounterRecord> counters;

    public CountersSample(ByteBuffer buffer) throws InvalidPacketException {
        this.sequence_number = BufferUtils.uint32((ByteBuffer)buffer);
        this.source_id = new SflowDataSource(buffer);
        this.counters = new Array<Object>(buffer, Optional.empty(), CounterRecord::new);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("sequence_number", this.sequence_number).add("source_id", (Object)this.source_id).add("counters", this.counters).toString();
    }

    @Override
    public void writeBson(BsonWriter bsonWriter) {
        bsonWriter.writeStartDocument();
        bsonWriter.writeInt64("sequence_number", this.sequence_number);
        bsonWriter.writeName("source_id");
        this.source_id.writeBson(bsonWriter);
        bsonWriter.writeStartDocument("counters");
        for (CounterRecord counterRecord : this.counters) {
            bsonWriter.writeName(counterRecord.dataFormat.toId());
            counterRecord.writeBson(bsonWriter);
        }
        bsonWriter.writeEndDocument();
        bsonWriter.writeEndDocument();
    }
}

